/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadNodeRecordsStep
extends ReadRecordsStep<NodeRecord> {
    private long id;

    public ReadNodeRecordsStep(StageControl control, Configuration config, NodeStore nodeStore) {
        super(control, config, nodeStore);
    }

    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize) {
        int size = (int)Math.min((long)batchSize, this.highId - this.id);
        AbstractBaseRecord[] batch = new NodeRecord[size];
        boolean seenReservedId = false;
        for (int i = 0; i < size; ++i) {
            this.cursor.next(this.id++);
            NodeRecord newRecord = ((NodeRecord)this.record).clone();
            batch[i] = newRecord;
            seenReservedId |= IdValidator.isReservedId(newRecord.getId());
        }
        return (batch = (NodeRecord[])this.removeRecordWithReservedId(batch, seenReservedId)).length > 0 ? batch : null;
    }

    @Override
    protected long position() {
        return this.id * (long)this.store.getRecordSize();
    }
}

