/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.lang.reflect.Array;
import java.util.Arrays;

public enum UpdateBehaviour {
    OVERWRITE{

        @Override
        public Object merge(Object existing, Object additional) {
            return additional;
        }
    }
    ,
    ADD{

        @Override
        public Object merge(Object existing, Object additional) {
            Object[] result;
            if (existing.getClass().isArray()) {
                result = Arrays.copyOf((Object[])existing, Array.getLength(existing) + 1);
                result[result.length - 1] = additional;
            } else if (additional.getClass().isArray()) {
                int length = Array.getLength(additional);
                result = (Object[])Array.newInstance(existing.getClass(), 1 + length);
                result[0] = existing;
                for (int i = 0; i < length; ++i) {
                    result[1 + i] = Array.get(additional, i);
                }
            } else {
                result = (Object[])Array.newInstance(existing.getClass(), 2);
                result[0] = existing;
                result[1] = additional;
            }
            return result;
        }
    };


    public abstract Object merge(Object var1, Object var2);
}

