/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.CursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;

final class MuninnWritePageCursor
extends MuninnPageCursor {
    private final CursorPool.CursorSets cursorSets;
    MuninnWritePageCursor nextCursor;

    MuninnWritePageCursor(CursorPool.CursorSets cursorSets, long victimPage) {
        super(victimPage);
        this.cursorSets = cursorSets;
    }

    @Override
    protected void unpinCurrentPage() {
        if (this.page != null) {
            this.page.markAsDirty();
            this.pinEvent.done();
            this.unlockPage(this.page);
        }
        this.clearPageState();
    }

    @Override
    public boolean next() throws IOException {
        this.unpinCurrentPage();
        long lastPageId = this.assertPagedFileStillMappedAndGetIdOfLastPage();
        if (this.nextPageId > lastPageId) {
            if ((this.pf_flags & 4) != 0) {
                return false;
            }
            this.pagedFile.increaseLastPageIdTo(this.nextPageId);
        }
        this.pin(this.nextPageId, true);
        this.currentPageId = this.nextPageId++;
        return true;
    }

    @Override
    protected boolean tryLockPage(MuninnPage page) {
        return page.tryWriteLock();
    }

    @Override
    protected void unlockPage(MuninnPage page) {
        page.unlockWrite();
    }

    @Override
    protected void pinCursorToPage(MuninnPage page, long filePageId, PageSwapper swapper) {
        this.reset(page);
        this.assertPagedFileStillMappedAndGetIdOfLastPage();
        page.incrementUsage();
    }

    @Override
    protected void convertPageFaultLock(MuninnPage page) {
        page.unlockExclusiveAndTakeWriteLock();
    }

    @Override
    protected void releaseCursor() {
        this.nextCursor = this.cursorSets.writeCursors;
        this.cursorSets.writeCursors = this;
    }

    @Override
    public final boolean shouldRetry() {
        return false;
    }
}

