/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.InvalidState;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.Resource;
import org.neo4j.codegen.TryBlock;
import org.neo4j.codegen.TypeReference;

public class CodeBlock
implements AutoCloseable {
    final ClassGenerator clazz;
    private MethodEmitter emitter;
    private final CodeBlock parent;
    private boolean done;

    CodeBlock(CodeBlock parent) {
        this.clazz = parent.clazz;
        this.emitter = parent.emitter;
        parent.emitter = InvalidState.IN_SUB_BLOCK;
        this.parent = parent;
    }

    CodeBlock(ClassGenerator clazz, MethodEmitter emitter) {
        this.clazz = clazz;
        this.emitter = emitter;
        this.parent = null;
    }

    public ClassGenerator classGenerator() {
        return this.clazz;
    }

    @Override
    public void close() {
        this.endBlock();
        if (this.parent != null) {
            this.parent.emitter = this.emitter;
        } else {
            this.emitter.done();
        }
        this.emitter = InvalidState.BLOCK_CLOSED;
    }

    private void endBlock() {
        if (!this.done) {
            this.emitter.endBlock();
            this.done = true;
        }
    }

    public void expression(Expression expression) {
        this.emitter.expression(expression);
    }

    TypeReference local(String name) {
        return null;
    }

    public LocalVariable declare(TypeReference type, String name) {
        LocalVariable local = new LocalVariable(type, name);
        this.emitter.declare(local);
        return local;
    }

    public void assign(LocalVariable local, Expression value) {
        this.emitter.assign(local, value);
    }

    public void assign(Class<?> type, String name, Expression value) {
        this.assign(TypeReference.typeReference(type), name, value);
    }

    public void assign(TypeReference type, String name, Expression value) {
        this.emitter.assign(type, name, value);
    }

    public void put(Expression target, FieldReference field, Expression value) {
        this.emitter.put(target, field, value);
    }

    public Expression self() {
        return this.load("this");
    }

    public Expression load(String name) {
        return Expression.load(this.local(name), name);
    }

    public CodeBlock forEach(Parameter local, Expression iterable) {
        this.emitter.beginForEach(local, iterable);
        return new CodeBlock(this);
    }

    public CodeBlock whileLoop(Expression test) {
        this.emitter.beginWhile(test);
        return new CodeBlock(this);
    }

    public CodeBlock ifStatement(Expression test) {
        this.emitter.beginIf(test);
        return new CodeBlock(this);
    }

    CodeBlock emitCatch(Parameter exception) {
        this.endBlock();
        this.emitter.beginCatch(exception);
        return new CodeBlock(this);
    }

    CodeBlock emitFinally() {
        this.endBlock();
        this.emitter.beginFinally();
        return new CodeBlock(this);
    }

    public CodeBlock tryBlock(Class<?> resourceType, String resourceName, Expression resource) {
        return this.tryBlock(Resource.withResource(resourceType, resourceName, resource));
    }

    public CodeBlock tryBlock(TypeReference resourceType, String resourceName, Expression resource) {
        return this.tryBlock(Resource.withResource(resourceType, resourceName, resource));
    }

    public TryBlock tryBlock(Resource ... resources) {
        this.emitter.beginTry(resources);
        return new TryBlock(this);
    }

    public void returns() {
        this.emitter.returns();
    }

    public void returns(Expression value) {
        this.emitter.returns(value);
    }

    public void throwException(Expression exception) {
        this.emitter.throwException(exception);
    }

    public TypeReference owner() {
        return this.clazz.handle();
    }
}

