/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.runtime.GrowingArray$;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u000e\u001d\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u001d\u0002\u0001\r\u0011\"\u0003P\u0011\u001d\u0019\u0006\u00011A\u0005\nQCaA\u0017\u0001!B\u0013\u0001\u0006bB.\u0001\u0001\u0004%I\u0001\u0018\u0005\bA\u0002\u0001\r\u0011\"\u0003b\u0011\u0019\u0019\u0007\u0001)Q\u0005;\"9A\r\u0001a\u0001\n\u0013)\u0007bB5\u0001\u0001\u0004%IA\u001b\u0005\u0007Y\u0002\u0001\u000b\u0015\u00024\t\u000b5\u0004A\u0011\u00018\t\u000bM\u0004A\u0011\u0001;\t\u000bY\u0004A\u0011A<\t\u000by\u0004A\u0011A@\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u000f\u001d\t9\u0003\bE\u0001\u0003S1aa\u0007\u000f\t\u0002\u0005-\u0002BB\u001e\u0016\t\u0003\ti\u0003\u0003\u0005\u00020U\u0011\r\u0011\"\u0001]\u0011\u001d\t\t$\u0006Q\u0001\nuC\u0001\"a\r\u0016\u0005\u0004%\ta\u0014\u0005\b\u0003k)\u0002\u0015!\u0003Q\u000519%o\\<j]\u001e\f%O]1z\u0015\tib$A\u0004sk:$\u0018.\\3\u000b\u0005}\u0001\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u0005\u0012\u0013AB2za\",'O\u0003\u0002$I\u0005)a.Z85U*\tQ%A\u0002pe\u001e\u001c\u0001!\u0006\u0002)\u0003N\u0019\u0001!K\u0019\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t1qJ\u00196fGR\u0004\"A\u000b\u001a\n\u0005MZ#!D!vi>\u001cEn\\:fC\ndW-A\u0007nK6|'/\u001f+sC\u000e\\WM\u001d\t\u0003mej\u0011a\u000e\u0006\u0003q\t\na!\\3n_JL\u0018B\u0001\u001e8\u00055iU-\\8ssR\u0013\u0018mY6fe\u00061A(\u001b8jiz\"\"!P'\u0011\u0007y\u0002q(D\u0001\u001d!\t\u0001\u0015\t\u0004\u0001\u0005\u000b\t\u0003!\u0019A\"\u0003\u0003Q\u000b\"\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\u000f9{G\u000f[5oOB\u0011QiS\u0005\u0003\u0019\u001a\u0013a!\u00118z%\u00164\u0007\"\u0002\u001b\u0003\u0001\u0004)\u0014!\u0004;sC\u000e\\W\rZ'f[>\u0014\u00180F\u0001Q!\t)\u0015+\u0003\u0002S\r\n!Aj\u001c8h\u0003E!(/Y2lK\u0012lU-\\8ss~#S-\u001d\u000b\u0003+b\u0003\"!\u0012,\n\u0005]3%\u0001B+oSRDq!\u0017\u0003\u0002\u0002\u0003\u0007\u0001+A\u0002yIE\na\u0002\u001e:bG.,G-T3n_JL\b%A\u0007iS\u001eDw+\u0019;fe6\u000b'o[\u000b\u0002;B\u0011QIX\u0005\u0003?\u001a\u00131!\u00138u\u0003EA\u0017n\u001a5XCR,'/T1sW~#S-\u001d\u000b\u0003+\nDq!W\u0004\u0002\u0002\u0003\u0007Q,\u0001\biS\u001eDw+\u0019;fe6\u000b'o\u001b\u0011\u0002\u000b\u0005\u0014(/Y=\u0016\u0003\u0019\u00042!R4K\u0013\tAgIA\u0003BeJ\f\u00170A\u0005beJ\f\u0017p\u0018\u0013fcR\u0011Qk\u001b\u0005\b3*\t\t\u00111\u0001g\u0003\u0019\t'O]1zA\u0005\u00191/\u001a;\u0015\u0007U{\u0017\u000fC\u0003q\u0019\u0001\u0007Q,A\u0003j]\u0012,\u0007\u0010C\u0003s\u0019\u0001\u0007q(A\u0001u\u0003\r9W\r\u001e\u000b\u0003\u007fUDQ\u0001]\u0007A\u0002u\u000bqbY8naV$X-\u00134BEN,g\u000e\u001e\u000b\u0004\u007faL\b\"\u00029\u000f\u0001\u0004i\u0006\"\u0002>\u000f\u0001\u0004Y\u0018aB2p[B,H/\u001a\t\u0004\u000br|\u0014BA?G\u0005%1UO\\2uS>t\u0007'A\u0004g_J,\u0017m\u00195\u0015\u0007U\u000b\t\u0001C\u0004\u0002\u0004=\u0001\r!!\u0002\u0002\u0003\u0019\u0004R!RA\u0004\u007fUK1!!\u0003G\u0005%1UO\\2uS>t\u0017'\u0001\tiCNtUM^3s'\u0016,g\u000eR1uCV\u0011\u0011q\u0002\t\u0004\u000b\u0006E\u0011bAA\n\r\n9!i\\8mK\u0006t\u0017aC5t\t\u00164\u0017N\\3e\u0003R$B!a\u0004\u0002\u001a!)\u0001/\u0005a\u0001;\u0006)1\r\\8tKR\tQ+\u0001\bf]N,(/Z\"ba\u0006\u001c\u0017\u000e^=\u0015\u0007U\u000b\u0019\u0003\u0003\u0004\u0002&M\u0001\r!X\u0001\u0005g&TX-\u0001\u0007He><\u0018N\\4BeJ\f\u0017\u0010\u0005\u0002?+M\u0011QC\u0013\u000b\u0003\u0003S\tA\u0002R#G\u0003VcEkX*J5\u0016\u000bQ\u0002R#G\u0003VcEkX*J5\u0016\u0003\u0013\u0001D*I\u00032cujV0T\u0013j+\u0015!D*I\u00032cujV0T\u0013j+\u0005\u0005")
public class GrowingArray<T>
implements AutoCloseable {
    private final MemoryTracker memoryTracker;
    private long trackedMemory;
    private int highWaterMark;
    private Object[] array;

    public static long SHALLOW_SIZE() {
        return GrowingArray$.MODULE$.SHALLOW_SIZE();
    }

    public static int DEFAULT_SIZE() {
        return GrowingArray$.MODULE$.DEFAULT_SIZE();
    }

    private long trackedMemory() {
        return this.trackedMemory;
    }

    private void trackedMemory_$eq(long x$1) {
        this.trackedMemory = x$1;
    }

    private int highWaterMark() {
        return this.highWaterMark;
    }

    private void highWaterMark_$eq(int x$1) {
        this.highWaterMark = x$1;
    }

    private Object[] array() {
        return this.array;
    }

    private void array_$eq(Object[] x$1) {
        this.array = x$1;
    }

    public void set(int index, T t) {
        this.ensureCapacity(index + 1);
        this.array()[index] = t;
    }

    public T get(int index) {
        return (T)this.array()[index];
    }

    /*
     * WARNING - void declaration
     */
    public T computeIfAbsent(int index, Function0<T> compute) {
        void var3_3;
        block0: {
            this.ensureCapacity(index + 1);
            Object t = this.array()[index];
            if (t != null) break block0;
            this.array()[index] = t = compute.apply();
        }
        return var3_3;
    }

    public void foreach(Function1<T, BoxedUnit> f) {
        for (int i = 0; i < this.highWaterMark(); ++i) {
            T t = this.get(i);
            Object object = t != null ? f.apply(t) : BoxedUnit.UNIT;
        }
    }

    public boolean hasNeverSeenData() {
        return this.highWaterMark() == 0;
    }

    public boolean isDefinedAt(int index) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(this.array())).isDefinedAt(index) && this.array()[index] != null;
    }

    @Override
    public void close() {
        block0: {
            if (this.array() == null) break block0;
            this.memoryTracker.releaseHeap(this.trackedMemory() + GrowingArray$.MODULE$.SHALLOW_SIZE());
            this.array_$eq(null);
        }
    }

    private void ensureCapacity(int size) {
        block1: {
            if (this.highWaterMark() < size) {
                this.highWaterMark_$eq(size);
            }
            if (this.array().length >= size) break block1;
            Object[] temp = this.array();
            long oldHeapUsage = this.trackedMemory();
            int newLength = package$.MODULE$.max(this.array().length * 2, size);
            this.trackedMemory_$eq(HeapEstimator.shallowSizeOfObjectArray((int)newLength));
            this.memoryTracker.allocateHeap(this.trackedMemory());
            this.array_$eq(new Object[newLength]);
            System.arraycopy(temp, 0, this.array(), 0, temp.length);
            this.memoryTracker.releaseHeap(oldHeapUsage);
        }
    }

    public GrowingArray(MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        this.trackedMemory = HeapEstimator.shallowSizeOfObjectArray((int)GrowingArray$.MODULE$.DEFAULT_SIZE());
        memoryTracker.allocateHeap(this.trackedMemory() + GrowingArray$.MODULE$.SHALLOW_SIZE());
        this.highWaterMark = 0;
        this.array = new Object[GrowingArray$.MODULE$.DEFAULT_SIZE()];
    }
}

