/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.UUID;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphDbmsModel;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.DatabaseIdRepository;

public class DefaultSystemGraphComponent
extends AbstractSystemGraphComponent {
    private final NormalizedDatabaseName defaultDbName;

    public DefaultSystemGraphComponent(Config config) {
        super(config);
        this.defaultDbName = new NormalizedDatabaseName((String)config.get(GraphDatabaseSettings.default_database));
    }

    public String component() {
        return "multi-database";
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return this.hasDatabaseNode(tx) ? (this.hasSystemDatabaseNode(tx) ? SystemGraphComponent.Status.CURRENT : SystemGraphComponent.Status.UNSUPPORTED) : SystemGraphComponent.Status.UNINITIALIZED;
    }

    protected void initializeSystemGraphConstraints(Transaction tx) {
        this.initializeSystemGraphConstraint(tx, SystemGraphDbmsModel.DATABASE_LABEL, "name");
    }

    public void initializeSystemGraphModel(GraphDatabaseService system) throws InvalidArgumentsException {
        this.newDefaultDb(system);
        this.newDb(system, new NormalizedDatabaseName("system"), false, DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID.databaseId().uuid());
    }

    protected void maybeStopDatabase(Node oldDatabaseNode) {
        oldDatabaseNode.setProperty("status", (Object)"offline");
    }

    protected void verifySystemGraph(GraphDatabaseService system) throws Exception {
        this.updateDefaultDatabase(system);
    }

    public void upgradeToCurrent(GraphDatabaseService system) {
    }

    private boolean hasDatabaseNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(SystemGraphDbmsModel.DATABASE_LABEL);){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    private boolean hasSystemDatabaseNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(SystemGraphDbmsModel.DATABASE_LABEL, "name", (Object)"system");){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    private void updateDefaultDatabase(GraphDatabaseService system) throws InvalidArgumentsException {
        boolean defaultFound;
        try (Transaction tx = system.beginTx();){
            Node defaultDb;
            Function<ResourceIterator, Boolean> unsetOldNode = nodes -> {
                boolean correctDefaultFound = false;
                while (nodes.hasNext()) {
                    Node oldDb = (Node)nodes.next();
                    if (oldDb.getProperty("name").equals(this.defaultDbName.name())) {
                        correctDefaultFound = true;
                        continue;
                    }
                    oldDb.setProperty("default", (Object)false);
                    this.maybeStopDatabase(oldDb);
                }
                return correctDefaultFound;
            };
            try (ResourceIterator nodes2 = tx.findNodes(SystemGraphDbmsModel.DATABASE_LABEL, "default", (Object)true);){
                defaultFound = unsetOldNode.apply(nodes2);
            }
            nodes2 = tx.findNodes(SystemGraphDbmsModel.DELETED_DATABASE_LABEL, "default", (Object)true);
            try {
                unsetOldNode.apply(nodes2);
            }
            finally {
                if (nodes2 != null) {
                    nodes2.close();
                }
            }
            if (!defaultFound && (defaultDb = tx.findNode(SystemGraphDbmsModel.DATABASE_LABEL, "name", (Object)this.defaultDbName.name())) != null) {
                defaultDb.setProperty("default", (Object)true);
                defaultDb.setProperty("status", (Object)"online");
                defaultFound = true;
            }
            tx.commit();
        }
        if (!defaultFound) {
            this.newDb(system, this.defaultDbName, true, UUID.randomUUID());
        }
    }

    private void newDefaultDb(GraphDatabaseService system) throws InvalidArgumentsException {
        this.newDb(system, this.defaultDbName, true, UUID.randomUUID());
    }

    private void newDb(GraphDatabaseService system, NormalizedDatabaseName databaseName, boolean defaultDb, UUID uuid) throws InvalidArgumentsException {
        try (Transaction tx = system.beginTx();){
            Node node = tx.createNode(new Label[]{SystemGraphDbmsModel.DATABASE_LABEL});
            node.setProperty("name", (Object)databaseName.name());
            node.setProperty("uuid", (Object)uuid.toString());
            node.setProperty("status", (Object)"online");
            node.setProperty("default", (Object)defaultDb);
            tx.commit();
        }
        catch (ConstraintViolationException e) {
            throw new InvalidArgumentsException("The specified database '" + databaseName + "' already exists.");
        }
    }
}

