/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.identity;

import java.io.IOException;
import java.util.UUID;
import org.neo4j.dbms.identity.StandaloneServerId;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.marshal.SafeChannelMarshal;

public interface ServerId {
    public static ServerId of(UUID id) {
        return new StandaloneServerId(id);
    }

    public UUID getUuid();

    public static class Marshal
    extends SafeChannelMarshal<ServerId> {
        public static final Marshal INSTANCE = new Marshal();

        public void marshal(ServerId serverId, WritableChannel channel) throws IOException {
            if (serverId == null) {
                channel.put((byte)0);
            } else {
                channel.put((byte)1);
                channel.putLong(serverId.getUuid().getMostSignificantBits());
                channel.putLong(serverId.getUuid().getLeastSignificantBits());
            }
        }

        public ServerId unmarshal0(ReadableChannel channel) throws IOException {
            byte nullMarker = channel.get();
            if (nullMarker == 0) {
                return null;
            }
            long mostSigBits = channel.getLong();
            long leastSigBits = channel.getLong();
            return ServerId.of(new UUID(mostSigBits, leastSigBits));
        }
    }
}

