/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.identity;

import java.util.UUID;
import org.neo4j.dbms.identity.DefaultIdentityModule;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.state.SimpleStorage;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;

public class StandaloneIdentityModule
extends DefaultIdentityModule {
    private final ServerId myself;

    public static StandaloneIdentityModule create(LogProvider logProvider, FileSystemAbstraction fs, Neo4jLayout layout, MemoryTracker memoryTracker) {
        Log log = logProvider.getLog(StandaloneIdentityModule.class);
        SimpleStorage<ServerId> storage = StandaloneIdentityModule.createServerIdStorage(fs, layout.serverIdFile(), memoryTracker);
        ServerId myself = StandaloneIdentityModule.readOrGenerate(storage, log, ServerId.class, ServerId::of, UUID::randomUUID);
        return new StandaloneIdentityModule(myself);
    }

    protected StandaloneIdentityModule(ServerId myself) {
        this.myself = myself;
    }

    @Override
    public ServerId myself() {
        return this.myself;
    }
}

