/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.procedures;

import java.util.Arrays;
import java.util.Optional;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.dbms.OperatorState;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.procedure.Mode;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public abstract class DatabaseStateProcedure
extends CallableProcedure.BasicProcedure {
    private static final String PROCEDURE_NAME = "state";
    private static final String[] PROCEDURE_NAMESPACE = new String[]{"dbms", "database"};
    private static final String PARAMETER_NAME = "databaseName";
    protected final DatabaseIdRepository idRepository;

    protected DatabaseStateProcedure(DatabaseIdRepository idRepository) {
        super(ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName(PROCEDURE_NAMESPACE, PROCEDURE_NAME)).in(PARAMETER_NAME, (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("role", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("address", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("status", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("error", (Neo4jTypes.AnyType)Neo4jTypes.NTString).description("The actual status of the database with the provided name on this neo4j instance.").systemProcedure().mode(Mode.DBMS).build());
        this.idRepository = idRepository;
    }

    protected NamedDatabaseId extractDatabaseId(AnyValue[] input) throws ProcedureException {
        if (input.length != 1) {
            throw new IllegalArgumentException("Illegal input:" + Arrays.toString(input));
        }
        AnyValue rawName = input[0];
        if (!(rawName instanceof TextValue)) {
            throw new IllegalArgumentException(String.format("Parameter '%s' value should have a string representation. Instead: %s", PARAMETER_NAME, rawName));
        }
        NormalizedDatabaseName name = new NormalizedDatabaseName(((TextValue)rawName).stringValue());
        return (NamedDatabaseId)this.idRepository.getByName(name).orElseThrow(() -> new ProcedureException((Status)Status.Database.DatabaseNotFound, String.format("Unable to retrieve the status for database with name %s because no database with this name exists!", name), new Object[0]));
    }

    protected AnyValue[] resultRowFactory(OperatorState status, Optional<String> error, String role, String address) {
        TextValue formattedStatus = Values.stringValue((String)status.description());
        TextValue formattedError = error.map(Values::stringValue).orElse(Values.EMPTY_STRING);
        return new AnyValue[]{Values.stringValue((String)role), Values.stringValue((String)address), formattedStatus, formattedError};
    }
}

