/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.procedures;

import java.util.Optional;
import org.neo4j.collection.RawIterator;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.OperatorState;
import org.neo4j.dbms.procedures.DatabaseStateProcedure;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.AnyValue;

public class StandaloneDatabaseStateProcedure
extends DatabaseStateProcedure {
    private final DatabaseStateService stateService;
    private final String advertisedAddress;

    public StandaloneDatabaseStateProcedure(DatabaseStateService stateService, DatabaseIdRepository idRepository, String advertisedAddress) {
        super(idRepository);
        this.stateService = stateService;
        this.advertisedAddress = advertisedAddress;
    }

    public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceTracker resourceTracker) throws ProcedureException {
        NamedDatabaseId databaseId = this.extractDatabaseId(input);
        OperatorState status = this.stateService.stateOfDatabase(databaseId).operatorState();
        Optional<String> error = this.stateService.causeOfFailure(databaseId).map(Throwable::getMessage);
        AnyValue[] resultRow = this.resultRowFactory(status, error, "standalone", this.advertisedAddress);
        return RawIterator.of((Object[])new AnyValue[][]{resultRow});
    }
}

