/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.LocksFactory;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.logging.internal.LogService;
import org.neo4j.service.Services;
import org.neo4j.time.SystemNanoClock;

public final class EditionLocksFactories {
    private EditionLocksFactories() {
    }

    public static Locks createLockManager(LocksFactory locksFactory, Config config, SystemNanoClock clock) {
        return locksFactory.newInstance(config, clock, (ResourceType[])ResourceTypes.values());
    }

    public static LocksFactory createLockFactory(Config config, LogService logService) {
        LocksFactory locksFactory = EditionLocksFactories.getLocksFactory((String)config.get(GraphDatabaseInternalSettings.lock_manager));
        logService.getInternalLog(EditionLocksFactories.class).info("Locking implementation '" + locksFactory.getName() + "' selected.");
        return locksFactory;
    }

    private static LocksFactory getLocksFactory(String key) {
        if (key.isEmpty()) {
            return (LocksFactory)Services.loadByPriority(LocksFactory.class).orElseThrow(() -> new IllegalArgumentException("No lock manager found"));
        }
        return (LocksFactory)Services.load(LocksFactory.class, (String)key).orElseThrow(() -> new IllegalArgumentException("No lock manager found with the name '" + key + "'."));
    }
}

