/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import java.time.Clock;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DatabaseConfig;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.context.EditionDatabaseComponents;
import org.neo4j.graphdb.factory.module.id.DatabaseIdContext;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.kernel.monitoring.DatabasePanicEventGenerator;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;

public class ModularDatabaseCreationContext
implements DatabaseCreationContext {
    private final NamedDatabaseId namedDatabaseId;
    private final Config globalConfig;
    private final DatabaseConfig databaseConfig;
    private final QueryEngineProvider queryEngineProvider;
    private final IdGeneratorFactory idGeneratorFactory;
    private final DatabaseLogService databaseLogService;
    private final JobScheduler scheduler;
    private final DependencyResolver globalDependencies;
    private final TokenHolders tokenHolders;
    private final Locks locks;
    private final StatementLocksFactory statementLocksFactory;
    private final FileSystemAbstraction fs;
    private final DatabaseTransactionStats transactionStats;
    private final Factory<DatabaseHealth> databaseHealthFactory;
    private final CommitProcessFactory commitProcessFactory;
    private final PageCache pageCache;
    private final ConstraintSemantics constraintSemantics;
    private final Monitors parentMonitors;
    private final Tracers tracers;
    private final GlobalProcedures globalProcedures;
    private final IOLimiter ioLimiter;
    private final LongFunction<DatabaseAvailabilityGuard> databaseAvailabilityGuardFactory;
    private final SystemNanoClock clock;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private final IdController idController;
    private final DbmsInfo dbmsInfo;
    private final VersionContextSupplier versionContextSupplier;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final Iterable<ExtensionFactory<?>> extensionFactories;
    private final Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
    private final DatabaseLayout databaseLayout;
    private final DatabaseEventListeners eventListeners;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final StorageEngineFactory storageEngineFactory;
    private final FileLockerService fileLockerService;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final LeaseService leaseService;
    private final DatabaseStartupController startupController;
    private final GlobalMemoryGroupTracker transactionsMemoryPool;
    private final GlobalMemoryGroupTracker otherMemoryPool;

    public ModularDatabaseCreationContext(NamedDatabaseId namedDatabaseId, GlobalModule globalModule, Dependencies globalDependencies, Monitors parentMonitors, EditionDatabaseComponents editionComponents, GlobalProcedures globalProcedures, VersionContextSupplier versionContextSupplier, DatabaseConfig databaseConfig, LeaseService leaseService) {
        this.namedDatabaseId = namedDatabaseId;
        this.globalConfig = globalModule.getGlobalConfig();
        this.databaseConfig = databaseConfig;
        this.versionContextSupplier = versionContextSupplier;
        this.queryEngineProvider = editionComponents.getQueryEngineProvider();
        DatabaseIdContext idContext = editionComponents.getIdContext();
        this.idGeneratorFactory = idContext.getIdGeneratorFactory();
        this.idController = idContext.getIdController();
        this.transactionsMemoryPool = globalModule.getTransactionsMemoryPool();
        this.otherMemoryPool = globalModule.getOtherMemoryPool();
        this.databaseLayout = globalModule.getNeo4jLayout().databaseLayout(namedDatabaseId.name());
        this.databaseLogService = new DatabaseLogService(namedDatabaseId, globalModule.getLogService());
        this.scheduler = globalModule.getJobScheduler();
        this.globalDependencies = globalDependencies;
        this.tokenHolders = editionComponents.getTokenHolders();
        this.locks = editionComponents.getLocks();
        this.statementLocksFactory = editionComponents.getStatementLocksFactory();
        this.transactionEventListeners = globalModule.getTransactionEventListeners();
        this.parentMonitors = parentMonitors;
        this.fs = globalModule.getFileSystem();
        this.transactionStats = editionComponents.getTransactionMonitor();
        this.eventListeners = globalModule.getDatabaseEventListeners();
        this.databaseHealthFactory = () -> new DatabaseHealth((PanicEventGenerator)new DatabasePanicEventGenerator(this.eventListeners, namedDatabaseId), this.databaseLogService.getInternalLog(DatabaseHealth.class));
        this.commitProcessFactory = editionComponents.getCommitProcessFactory();
        this.pageCache = globalModule.getPageCache();
        this.constraintSemantics = editionComponents.getConstraintSemantics();
        this.tracers = globalModule.getTracers();
        this.globalProcedures = globalProcedures;
        this.ioLimiter = editionComponents.getIoLimiter();
        this.clock = globalModule.getGlobalClock();
        this.storeCopyCheckPointMutex = new StoreCopyCheckPointMutex();
        this.dbmsInfo = globalModule.getDbmsInfo();
        this.collectionsFactorySupplier = globalModule.getCollectionsFactorySupplier();
        this.extensionFactories = globalModule.getExtensionFactories();
        this.watcherServiceFactory = editionComponents.getWatcherServiceFactory();
        this.databaseAvailabilityGuardFactory = databaseTimeoutMillis -> this.databaseAvailabilityGuardFactory(namedDatabaseId, globalModule, databaseTimeoutMillis);
        this.storageEngineFactory = globalModule.getStorageEngineFactory();
        this.fileLockerService = globalModule.getFileLockerService();
        this.accessCapabilityFactory = editionComponents.getAccessCapabilityFactory();
        this.leaseService = leaseService;
        this.startupController = editionComponents.getStartupController();
    }

    public NamedDatabaseId getNamedDatabaseId() {
        return this.namedDatabaseId;
    }

    public DatabaseLayout getDatabaseLayout() {
        return this.databaseLayout;
    }

    public Config getGlobalConfig() {
        return this.globalConfig;
    }

    public DatabaseConfig getDatabaseConfig() {
        return this.databaseConfig;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    public DatabaseLogService getDatabaseLogService() {
        return this.databaseLogService;
    }

    public JobScheduler getScheduler() {
        return this.scheduler;
    }

    public DependencyResolver getGlobalDependencies() {
        return this.globalDependencies;
    }

    public TokenHolders getTokenHolders() {
        return this.tokenHolders;
    }

    public Locks getLocks() {
        return this.locks;
    }

    public StatementLocksFactory getStatementLocksFactory() {
        return this.statementLocksFactory;
    }

    public GlobalTransactionEventListeners getTransactionEventListeners() {
        return this.transactionEventListeners;
    }

    public FileSystemAbstraction getFs() {
        return this.fs;
    }

    public DatabaseTransactionStats getTransactionStats() {
        return this.transactionStats;
    }

    public Factory<DatabaseHealth> getDatabaseHealthFactory() {
        return this.databaseHealthFactory;
    }

    public CommitProcessFactory getCommitProcessFactory() {
        return this.commitProcessFactory;
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public ConstraintSemantics getConstraintSemantics() {
        return this.constraintSemantics;
    }

    public Monitors getMonitors() {
        return this.parentMonitors;
    }

    public Tracers getTracers() {
        return this.tracers;
    }

    public GlobalProcedures getGlobalProcedures() {
        return this.globalProcedures;
    }

    public IOLimiter getIoLimiter() {
        return this.ioLimiter;
    }

    public LongFunction<DatabaseAvailabilityGuard> getDatabaseAvailabilityGuardFactory() {
        return this.databaseAvailabilityGuardFactory;
    }

    public SystemNanoClock getClock() {
        return this.clock;
    }

    public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
        return this.storeCopyCheckPointMutex;
    }

    public IdController getIdController() {
        return this.idController;
    }

    public DbmsInfo getDbmsInfo() {
        return this.dbmsInfo;
    }

    public VersionContextSupplier getVersionContextSupplier() {
        return this.versionContextSupplier;
    }

    public CollectionsFactorySupplier getCollectionsFactorySupplier() {
        return this.collectionsFactorySupplier;
    }

    public Iterable<ExtensionFactory<?>> getExtensionFactories() {
        return this.extensionFactories;
    }

    public Function<DatabaseLayout, DatabaseLayoutWatcher> getWatcherServiceFactory() {
        return this.watcherServiceFactory;
    }

    public QueryEngineProvider getEngineProvider() {
        return this.queryEngineProvider;
    }

    public DatabaseEventListeners getDatabaseEventListeners() {
        return this.eventListeners;
    }

    public StorageEngineFactory getStorageEngineFactory() {
        return this.storageEngineFactory;
    }

    public FileLockerService getFileLockerService() {
        return this.fileLockerService;
    }

    public AccessCapabilityFactory getAccessCapabilityFactory() {
        return this.accessCapabilityFactory;
    }

    public LeaseService getLeaseService() {
        return this.leaseService;
    }

    public DatabaseStartupController getStartupController() {
        return this.startupController;
    }

    public GlobalMemoryGroupTracker getTransactionsMemoryPool() {
        return this.transactionsMemoryPool;
    }

    public GlobalMemoryGroupTracker getOtherMemoryPool() {
        return this.otherMemoryPool;
    }

    private DatabaseAvailabilityGuard databaseAvailabilityGuardFactory(NamedDatabaseId namedDatabaseId, GlobalModule globalModule, long databaseTimeoutMillis) {
        Log guardLog = this.databaseLogService.getInternalLog(DatabaseAvailabilityGuard.class);
        return new DatabaseAvailabilityGuard(namedDatabaseId, (Clock)this.clock, guardLog, databaseTimeoutMillis, globalModule.getGlobalAvailabilityGuard());
    }
}

