/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.annotations.api.IgnoreApiCheck;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.context.EditionDatabaseComponents;
import org.neo4j.internal.collector.DataCollectorProcedures;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.fs.watcher.FileWatchEventListenerFactory;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.net.DefaultNetworkConnectionTracker;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.util.watcher.DefaultFileDeletionListenerFactory;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.procedure.builtin.BuiltInDbmsProcedures;
import org.neo4j.procedure.builtin.BuiltInProcedures;
import org.neo4j.procedure.builtin.FulltextProcedures;
import org.neo4j.procedure.builtin.TokenProcedures;
import org.neo4j.procedure.builtin.routing.BaseRoutingProcedureInstaller;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.time.SystemNanoClock;

@IgnoreApiCheck
public abstract class AbstractEditionModule {
    protected NetworkConnectionTracker connectionTracker;
    protected ConstraintSemantics constraintSemantics;
    protected IOLimiter ioLimiter;
    protected Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
    protected SecurityProvider securityProvider;

    public abstract EditionDatabaseComponents createDatabaseComponents(NamedDatabaseId var1);

    protected DatabaseLayoutWatcher createDatabaseFileSystemWatcher(FileWatcher watcher, DatabaseLayout databaseLayout, LogService logging, Predicate<String> fileNameFilter) {
        DefaultFileDeletionListenerFactory listenerFactory = new DefaultFileDeletionListenerFactory(databaseLayout, logging, fileNameFilter);
        return new DatabaseLayoutWatcher(watcher, databaseLayout, (FileWatchEventListenerFactory)listenerFactory);
    }

    public void registerProcedures(GlobalProcedures globalProcedures, ProcedureConfig procedureConfig, GlobalModule globalModule, DatabaseManager<?> databaseManager) throws KernelException {
        globalProcedures.registerProcedure(BuiltInProcedures.class);
        globalProcedures.registerProcedure(TokenProcedures.class);
        globalProcedures.registerProcedure(BuiltInDbmsProcedures.class);
        globalProcedures.registerProcedure(FulltextProcedures.class);
        globalProcedures.registerProcedure(DataCollectorProcedures.class);
        TemporalFunction.registerTemporalFunctions((GlobalProcedures)globalProcedures, (ProcedureConfig)procedureConfig);
        this.registerEditionSpecificProcedures(globalProcedures, databaseManager);
        BaseRoutingProcedureInstaller routingProcedureInstaller = this.createRoutingProcedureInstaller(globalModule, databaseManager);
        routingProcedureInstaller.install(globalProcedures);
    }

    protected abstract void registerEditionSpecificProcedures(GlobalProcedures var1, DatabaseManager<?> var2) throws KernelException;

    protected abstract BaseRoutingProcedureInstaller createRoutingProcedureInstaller(GlobalModule var1, DatabaseManager<?> var2);

    public abstract <DB extends DatabaseContext> DatabaseManager<DB> createDatabaseManager(GlobalModule var1);

    public abstract SystemGraphInitializer createSystemGraphInitializer(GlobalModule var1, DatabaseManager<?> var2);

    public abstract void createSecurityModule(GlobalModule var1);

    protected NetworkConnectionTracker createConnectionTracker() {
        return new DefaultNetworkConnectionTracker();
    }

    public DatabaseTransactionStats createTransactionMonitor() {
        return new DatabaseTransactionStats();
    }

    public ConstraintSemantics getConstraintSemantics() {
        return this.constraintSemantics;
    }

    public IOLimiter getIoLimiter() {
        return this.ioLimiter;
    }

    public Function<DatabaseLayout, DatabaseLayoutWatcher> getWatcherServiceFactory() {
        return this.watcherServiceFactory;
    }

    public NetworkConnectionTracker getConnectionTracker() {
        return this.connectionTracker;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public abstract QueryEngineProvider getQueryEngineProvider();

    public abstract void bootstrapFabricServices();

    public abstract BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider(Dependencies var1, DatabaseManagementService var2, Monitors var3, SystemNanoClock var4, LogService var5);

    public AuthManager getBoltAuthManager(DependencyResolver dependencyResolver) {
        return (AuthManager)dependencyResolver.resolveDependency(AuthManager.class);
    }

    public AuthManager getBoltInClusterAuthManager() {
        return this.securityProvider.inClusterAuthManager();
    }

    public abstract DatabaseStartupController getDatabaseStartupController();

    public abstract Lifecycle createWebServer(DatabaseManagementService var1, Dependencies var2, Config var3, LogProvider var4, DbmsInfo var5);

    public abstract DbmsRuntimeRepository createAndRegisterDbmsRuntimeRepository(GlobalModule var1, DatabaseManager<?> var2, Dependencies var3);
}

