/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.dbms.CommunityDatabaseStateService;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DefaultDatabaseManager;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.dbms.database.StandaloneDbmsRuntimeRepository;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.context.EditionDatabaseComponents;
import org.neo4j.graphdb.factory.module.edition.context.StandaloneDatabaseComponents;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.token.TokenHolders;

public abstract class StandaloneEditionModule
extends AbstractEditionModule {
    protected CommitProcessFactory commitProcessFactory;
    protected DatabaseStateService databaseStateService;
    IdContextFactory idContextFactory;
    Function<NamedDatabaseId, TokenHolders> tokenHoldersProvider;
    Supplier<Locks> locksSupplier;
    Function<Locks, StatementLocksFactory> statementLocksFactoryProvider;

    @Override
    public EditionDatabaseComponents createDatabaseComponents(NamedDatabaseId namedDatabaseId) {
        return new StandaloneDatabaseComponents(this, namedDatabaseId);
    }

    public CommitProcessFactory getCommitProcessFactory() {
        return this.commitProcessFactory;
    }

    public IdContextFactory getIdContextFactory() {
        return this.idContextFactory;
    }

    public Function<NamedDatabaseId, TokenHolders> getTokenHoldersProvider() {
        return this.tokenHoldersProvider;
    }

    public Supplier<Locks> getLocksSupplier() {
        return this.locksSupplier;
    }

    public Function<Locks, StatementLocksFactory> getStatementLocksFactoryProvider() {
        return this.statementLocksFactoryProvider;
    }

    public DatabaseManager<StandaloneDatabaseContext> createDatabaseManager(GlobalModule globalModule) {
        DefaultDatabaseManager databaseManager = new DefaultDatabaseManager(globalModule, this);
        this.databaseStateService = new CommunityDatabaseStateService(databaseManager);
        globalModule.getGlobalLife().add((Lifecycle)databaseManager);
        globalModule.getGlobalDependencies().satisfyDependency((Object)databaseManager);
        globalModule.getGlobalDependencies().satisfyDependency((Object)this.databaseStateService);
        return databaseManager;
    }

    @Override
    public DbmsRuntimeRepository createAndRegisterDbmsRuntimeRepository(GlobalModule globalModule, DatabaseManager<?> databaseManager, Dependencies dependencies) {
        StandaloneDbmsRuntimeRepository dbmsRuntimeRepository = new StandaloneDbmsRuntimeRepository(databaseManager);
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", (TransactionEventListener)dbmsRuntimeRepository);
        return dbmsRuntimeRepository;
    }
}

