/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.id;

import java.util.function.Function;
import org.neo4j.graphdb.factory.module.id.DatabaseIdContext;
import org.neo4j.internal.id.BufferedIdController;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.DefaultIdController;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.util.FeatureToggles;

public class IdContextFactory {
    private static final boolean ID_BUFFERING_FLAG = FeatureToggles.flag(IdContextFactory.class, (String)"safeIdBuffering", (boolean)true);
    private final JobScheduler jobScheduler;
    private final Function<NamedDatabaseId, IdGeneratorFactory> idFactoryProvider;
    private final Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper;
    private final PageCacheTracer cacheTracer;

    IdContextFactory(JobScheduler jobScheduler, Function<NamedDatabaseId, IdGeneratorFactory> idFactoryProvider, Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper, PageCacheTracer cacheTracer) {
        this.jobScheduler = jobScheduler;
        this.idFactoryProvider = idFactoryProvider;
        this.factoryWrapper = factoryWrapper;
        this.cacheTracer = cacheTracer;
    }

    public DatabaseIdContext createIdContext(NamedDatabaseId namedDatabaseId) {
        return ID_BUFFERING_FLAG ? this.createBufferingIdContext(this.idFactoryProvider, this.jobScheduler, this.cacheTracer, namedDatabaseId) : this.createDefaultIdContext(this.idFactoryProvider, namedDatabaseId);
    }

    private DatabaseIdContext createDefaultIdContext(Function<NamedDatabaseId, ? extends IdGeneratorFactory> idGeneratorFactoryProvider, NamedDatabaseId namedDatabaseId) {
        return this.createIdContext(idGeneratorFactoryProvider.apply(namedDatabaseId), (IdController)IdContextFactory.createDefaultIdController());
    }

    private DatabaseIdContext createBufferingIdContext(Function<NamedDatabaseId, ? extends IdGeneratorFactory> idGeneratorFactoryProvider, JobScheduler jobScheduler, PageCacheTracer cacheTracer, NamedDatabaseId namedDatabaseId) {
        IdGeneratorFactory idGeneratorFactory = idGeneratorFactoryProvider.apply(namedDatabaseId);
        BufferingIdGeneratorFactory bufferingIdGeneratorFactory = new BufferingIdGeneratorFactory(idGeneratorFactory);
        BufferedIdController bufferingController = IdContextFactory.createBufferedIdController(bufferingIdGeneratorFactory, jobScheduler, cacheTracer, namedDatabaseId.name());
        return this.createIdContext((IdGeneratorFactory)bufferingIdGeneratorFactory, (IdController)bufferingController);
    }

    private DatabaseIdContext createIdContext(IdGeneratorFactory idGeneratorFactory, IdController idController) {
        return new DatabaseIdContext(this.factoryWrapper.apply(idGeneratorFactory), idController);
    }

    private static BufferedIdController createBufferedIdController(BufferingIdGeneratorFactory idGeneratorFactory, JobScheduler scheduler, PageCacheTracer cacheTracer, String databaseName) {
        return new BufferedIdController(idGeneratorFactory, scheduler, cacheTracer, databaseName);
    }

    private static DefaultIdController createDefaultIdController() {
        return new DefaultIdController();
    }
}

