/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.neo4j.common.Validator;
import org.neo4j.internal.helpers.Args;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.impl.util.Converters;

public class CommandLineArgs {
    public static final String CONFIG_DIR_ARG = "config-dir";
    public static final String HOME_DIR_ARG = "home-dir";
    public static final String VERSION_ARG = "version";
    public static final String EXPAND_COMMAND_ARG = "expand-commands";
    private final Args args;
    private final Map<String, String> configOverrides;

    private CommandLineArgs(Args args, Map<String, String> configOverrides) {
        this.args = args;
        this.configOverrides = configOverrides;
    }

    public static CommandLineArgs parse(String[] argv) {
        Args args = Args.withFlags((String[])new String[]{VERSION_ARG}).parse(argv);
        return new CommandLineArgs(args, CommandLineArgs.parseConfigOverrides(args));
    }

    public Map<String, String> configOverrides() {
        return this.configOverrides;
    }

    public Path configFile() {
        String configDirectory = this.args.get(CONFIG_DIR_ARG);
        return configDirectory == null ? null : Path.of(configDirectory, "neo4j.conf");
    }

    private static Map<String, String> parseConfigOverrides(Args arguments) {
        Collection options = arguments.interpretOptions("c", Converters.optional(), s -> {
            if (s.contains("=")) {
                String[] keyVal = s.split("=", 2);
                return Pair.pair((Object)keyVal[0], (Object)keyVal[1]);
            }
            return Pair.pair((Object)s, (Object)"true");
        }, new Validator[0]);
        Map ret = MapUtil.stringMap((String[])new String[0]);
        options.forEach(pair -> ret.put((String)pair.first(), (String)pair.other()));
        return ret;
    }

    public Path homeDir() {
        if (this.args.get(HOME_DIR_ARG) == null) {
            return null;
        }
        return Path.of(this.args.get(HOME_DIR_ARG), new String[0]);
    }

    public boolean version() {
        return this.args.getBoolean(VERSION_ARG, Boolean.FALSE);
    }

    public boolean expandCommands() {
        return this.args.getBoolean(EXPAND_COMMAND_ARG, Boolean.FALSE);
    }
}

