/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.Closeable;
import java.io.OutputStream;
import java.lang.management.MemoryUsage;
import java.nio.file.Path;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.configuration.BufferingLog;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.memory.MachineMemory;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.CommandLineArgs;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.logging.JULBridge;
import org.neo4j.server.logging.JettyLogBridge;
import org.neo4j.util.VisibleForTesting;
import sun.misc.Signal;

public abstract class NeoBootstrapper
implements Bootstrapper {
    public static final int OK = 0;
    private static final int WEB_SERVER_STARTUP_ERROR_CODE = 1;
    private static final int GRAPH_DATABASE_STARTUP_ERROR_CODE = 2;
    private static final int INVALID_CONFIGURATION_ERROR_CODE = 3;
    private static final String SIGTERM = "TERM";
    private static final String SIGINT = "INT";
    private volatile DatabaseManagementService databaseManagementService;
    private volatile Closeable userLogFileStream;
    private Thread shutdownHook;
    private GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies();
    private final BufferingLog startupLog = new BufferingLog();
    private volatile Log log = this.startupLog;
    private String serverAddress = "unknown address";
    private MachineMemory machineMemory = MachineMemory.DEFAULT;

    public static int start(Bootstrapper boot, String ... argv) {
        CommandLineArgs args = CommandLineArgs.parse(argv);
        if (args.version()) {
            System.out.println("neo4j " + Version.getNeo4jVersion());
            return 0;
        }
        if (args.homeDir() == null) {
            throw new ServerStartupException("Argument --home-dir is required and was not provided.");
        }
        return boot.start(args.homeDir(), args.configFile(), args.configOverrides(), args.expandCommands());
    }

    @VisibleForTesting
    public final int start(Path homeDir, Map<String, String> configOverrides) {
        return this.start(homeDir, null, configOverrides, false);
    }

    @Override
    public final int start(Path homeDir, Path configFile, Map<String, String> configOverrides, boolean expandCommands) {
        this.addShutdownHook();
        NeoBootstrapper.installSignalHandlers();
        Config config = Config.newBuilder().commandExpansion(expandCommands).setDefaults(GraphDatabaseSettings.SERVER_DEFAULTS).fromFileNoThrow(configFile).setRaw(configOverrides).set(GraphDatabaseSettings.neo4j_home, (Object)homeDir.toAbsolutePath()).build();
        Log4jLogProvider userLogProvider = this.setupLogging(config);
        this.userLogFileStream = userLogProvider;
        this.dependencies = this.dependencies.userLogProvider((LogProvider)userLogProvider);
        this.log = userLogProvider.getLog(this.getClass());
        this.startupLog.replayInto(this.log);
        config.setLogger(this.log);
        if (this.requestedMemoryExceedsAvailable(config)) {
            this.log.error(String.format("Invalid memory configuration - exceeds physical memory. Check the configured values for %s and %s", GraphDatabaseSettings.pagecache_memory.name(), ExternalSettings.max_heap_size.name()));
            return 3;
        }
        try {
            this.serverAddress = HttpConnector.listen_address.toString();
            this.log.info("Starting...");
            this.databaseManagementService = this.createNeo(config, this.dependencies);
            this.log.info("Started.");
            return 0;
        }
        catch (ServerStartupException e) {
            e.describeTo(this.log);
            return 1;
        }
        catch (TransactionFailureException tfe) {
            String locationMsg = this.databaseManagementService == null ? "" : " Another process may be using databases at location: " + config.get(GraphDatabaseInternalSettings.databases_root_path);
            this.log.error(String.format("Failed to start Neo4j on %s.", this.serverAddress) + locationMsg, (Throwable)tfe);
            return 2;
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to start Neo4j on %s.", this.serverAddress), (Throwable)e);
            return 1;
        }
    }

    private boolean requestedMemoryExceedsAvailable(Config config) {
        String pageCacheMemory = (String)config.get(GraphDatabaseSettings.pagecache_memory);
        long pageCacheSize = pageCacheMemory == null ? ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory((MachineMemory)this.machineMemory) : ByteUnit.parse((String)pageCacheMemory);
        MemoryUsage heapMemoryUsage = this.machineMemory.getHeapMemoryUsage();
        long totalPhysicalMemory = this.machineMemory.getTotalPhysicalMemory();
        if (totalPhysicalMemory == 0L) {
            this.log.warn("Unable to determine total physical memory of machine. JVM is most likely running in a container that do not expose that.");
            return false;
        }
        return totalPhysicalMemory != -1L && pageCacheSize + heapMemoryUsage.getMax() > totalPhysicalMemory;
    }

    @Override
    public int stop() {
        String location = "unknown location";
        try {
            this.doShutdown();
            this.removeShutdownHook();
            this.closeUserLogFileStream();
            return 0;
        }
        catch (Exception e) {
            this.switchToErrorLoggingIfLoggingNotConfigured();
            this.log.error("Failed to cleanly shutdown Neo Server on port [%s], database [%s]. Reason [%s] ", new Object[]{this.serverAddress, location, e.getMessage(), e});
            this.closeUserLogFileStream();
            return 1;
        }
    }

    public boolean isRunning() {
        return this.databaseManagementService != null;
    }

    public DatabaseManagementService getDatabaseManagementService() {
        return this.databaseManagementService;
    }

    public Log getLog() {
        return this.log;
    }

    protected abstract DatabaseManagementService createNeo(Config var1, GraphDatabaseDependencies var2);

    private Log4jLogProvider setupLogging(Config config) {
        LogConfig.Builder builder = LogConfig.createBuilder((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (Path)((Path)config.get(GraphDatabaseSettings.store_user_log_path)), (Level)((Level)config.get(GraphDatabaseSettings.store_internal_log_level))).withTimezone((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).withFormat((FormattedLogFormat)config.get(GraphDatabaseInternalSettings.log_format)).withCategory(false).withRotation(((Long)config.get(GraphDatabaseSettings.store_user_log_rotation_threshold)).longValue(), ((Integer)config.get(GraphDatabaseSettings.store_user_log_max_archives)).intValue());
        if (((Boolean)config.get(GraphDatabaseSettings.store_user_log_to_stdout)).booleanValue()) {
            builder.logToSystemOut();
        }
        Neo4jLoggerContext ctx = builder.build();
        Log4jLogProvider userLogProvider = new Log4jLogProvider(ctx);
        JULBridge.resetJUL();
        Logger.getLogger("").setLevel(java.util.logging.Level.WARNING);
        JULBridge.forwardTo((LogProvider)userLogProvider);
        JettyLogBridge.setLogProvider((LogProvider)userLogProvider);
        return userLogProvider;
    }

    private static void installSignalHandlers() {
        NeoBootstrapper.installSignalHandler(SIGTERM, false);
        NeoBootstrapper.installSignalHandler(SIGINT, true);
    }

    private static void installSignalHandler(String sig, boolean tolerateErrors) {
        block2: {
            try {
                Signal.handle(new Signal(sig), signal -> System.exit(0));
            }
            catch (Throwable e) {
                if (tolerateErrors) break block2;
                throw e;
            }
        }
    }

    private void doShutdown() {
        this.switchToErrorLoggingIfLoggingNotConfigured();
        if (this.databaseManagementService != null) {
            this.log.info("Stopping...");
            this.databaseManagementService.shutdown();
        }
        this.log.info("Stopped.");
    }

    private void closeUserLogFileStream() {
        if (this.userLogFileStream != null) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new Closeable[]{this.userLogFileStream});
        }
    }

    private void addShutdownHook() {
        this.shutdownHook = new Thread(() -> {
            this.log.info("Neo4j Server shutdown initiated by request");
            this.doShutdown();
            this.closeUserLogFileStream();
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null && !Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
            this.log.warn("Unable to remove shutdown hook");
        }
    }

    private void switchToErrorLoggingIfLoggingNotConfigured() {
        if (this.userLogFileStream == null) {
            Log4jLogProvider outProvider = new Log4jLogProvider((OutputStream)System.out);
            this.userLogFileStream = outProvider;
            this.log = outProvider.getLog(this.getClass());
            this.startupLog.replayInto(this.log);
        }
    }

    @VisibleForTesting
    void setMachineMemory(MachineMemory machineMemory) {
        this.machineMemory = machineMemory;
    }
}

