/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Iterator;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.index.label.AllEntriesTokenScanReader;
import org.neo4j.internal.index.label.EntityTokenRange;
import org.neo4j.internal.index.label.TokenScanStore;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

class GapFreeAllEntriesTokenScanReader
implements AllEntriesTokenScanReader {
    private static final String GAP_FREE_ALL_ENTRIES_READER_TAG = "gapFreeAllEntriesReader";
    private final AllEntriesTokenScanReader entityTokenRanges;
    private final long highId;
    private final EntityType entityType;
    private final PageCursorTracer cursorTracer;

    GapFreeAllEntriesTokenScanReader(TokenScanStore scanStore, long highId, PageCacheTracer cacheTracer) {
        this.cursorTracer = cacheTracer.createPageCursorTracer(GAP_FREE_ALL_ENTRIES_READER_TAG);
        this.entityTokenRanges = scanStore.allEntityTokenRanges(this.cursorTracer);
        this.highId = highId;
        this.entityType = scanStore.entityType();
    }

    public long maxCount() {
        return this.entityTokenRanges.maxCount();
    }

    public void close() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.entityTokenRanges, this.cursorTracer});
    }

    public int rangeSize() {
        return this.entityTokenRanges.rangeSize();
    }

    public Iterator<EntityTokenRange> iterator() {
        long highestRangeId = 0L;
        int rangeSize = this.entityTokenRanges.rangeSize();
        if (rangeSize != 0) {
            highestRangeId = (this.highId - 1L) / (long)rangeSize;
        }
        return new GapFillingIterator(this.entityTokenRanges.iterator(), highestRangeId, rangeSize, this.entityType);
    }

    private static class GapFillingIterator
    extends PrefetchingIterator<EntityTokenRange> {
        private final long highestRangeId;
        private final Iterator<EntityTokenRange> source;
        private final long[][] emptyRangeData;
        private final EntityType entityType;
        private EntityTokenRange nextFromSource;
        private long currentRangeId = -1L;

        GapFillingIterator(Iterator<EntityTokenRange> entityTokenRangeIterator, long highestRangeId, int rangeSize, EntityType entityType) {
            this.highestRangeId = highestRangeId;
            this.source = entityTokenRangeIterator;
            this.emptyRangeData = new long[rangeSize][];
            this.entityType = entityType;
        }

        protected EntityTokenRange fetchNextOrNull() {
            while (true) {
                if (this.nextFromSource != null) {
                    if (this.currentRangeId + 1L == this.nextFromSource.id()) {
                        ++this.currentRangeId;
                        return this.nextFromSource;
                    }
                    if (this.currentRangeId < this.nextFromSource.id()) {
                        return new EntityTokenRange(++this.currentRangeId, this.emptyRangeData, this.entityType);
                    }
                }
                if (this.source.hasNext()) {
                    this.nextFromSource = this.source.next();
                    continue;
                }
                if (this.currentRangeId >= this.highestRangeId) break;
                this.nextFromSource = new EntityTokenRange(this.highestRangeId, this.emptyRangeData, this.entityType);
            }
            return null;
        }
    }
}

