/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.labelscan;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.synthetic.TokenScanDocument;
import org.neo4j.internal.index.label.EntityTokenRange;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class LabelScanCheck
implements RecordCheck<TokenScanDocument, ConsistencyReport.LabelScanConsistencyReport> {
    @Override
    public void check(TokenScanDocument record, CheckerEngine<TokenScanDocument, ConsistencyReport.LabelScanConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        EntityTokenRange range = record.getEntityTokenRange();
        for (long nodeId : range.entities()) {
            long[] labels = record.getEntityTokenRange().tokens(nodeId);
            engine.comparativeCheck(records.node(nodeId, cursorTracer), new NodeInUseWithCorrectLabelsCheck(labels, PropertySchemaType.COMPLETE_ALL_TOKENS, true));
        }
    }
}

