/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.CacheSlots;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.newchecker.BatchedRelationshipRecords;
import org.neo4j.consistency.newchecker.Checker;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.NodeLink;
import org.neo4j.consistency.newchecker.ParallelExecution;
import org.neo4j.consistency.newchecker.RecordLoading;
import org.neo4j.consistency.newchecker.RelationshipLink;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.time.Stopwatch;

class RelationshipChainChecker
implements Checker {
    private static final String RELATIONSHIP_CONSISTENCY_CHECKER_TAG = "relationshipConsistencyChecker";
    private static final String SINGLE_RELATIONSHIP_CONSISTENCY_CHECKER_TAG = "simpleChainsRelationshipConsistencyChecker";
    private final ConsistencyReport.Reporter reporter;
    private final CheckerContext context;
    private final int numberOfChainCheckers;
    private final CacheAccess cacheAccess;
    private final RecordLoading recordLoader;
    private final ProgressListener progress;

    RelationshipChainChecker(CheckerContext context) {
        this.context = context;
        this.reporter = context.reporter;
        this.numberOfChainCheckers = Math.max(1, context.execution.getNumberOfThreads() - 2);
        this.cacheAccess = context.cacheAccess;
        this.recordLoader = context.recordLoader;
        this.progress = context.progressReporter(this, "Relationship chains", context.neoStores.getRelationshipStore().getHighId() * 2L);
    }

    @Override
    public void check(LongRange nodeIdRange, boolean firstRange, boolean lastRange) throws Exception {
        this.checkDirection(nodeIdRange, ScanDirection.FORWARD);
        this.context.paddedDebug("%s moving over to backwards relationship chain checking", this.getClass().getSimpleName());
        this.checkDirection(nodeIdRange, ScanDirection.BACKWARD);
    }

    private void checkDirection(LongRange nodeIdRange, ScanDirection direction) throws Exception {
        RelationshipStore relationshipStore = this.context.neoStores.getRelationshipStore();
        long highId = relationshipStore.getHighId();
        AtomicBoolean end = new AtomicBoolean();
        int numberOfThreads = this.numberOfChainCheckers + 1;
        ParallelExecution.ThrowingRunnable[] workers = new ParallelExecution.ThrowingRunnable[numberOfThreads];
        ProgressListener localProgress = this.progress.threadLocalReporter();
        ArrayBlockingQueue[] threadQueues = new ArrayBlockingQueue[this.numberOfChainCheckers];
        BatchedRelationshipRecords[] threadBatches = new BatchedRelationshipRecords[this.numberOfChainCheckers];
        for (int i = 0; i < this.numberOfChainCheckers; ++i) {
            threadQueues[i] = new ArrayBlockingQueue(20);
            threadBatches[i] = new BatchedRelationshipRecords();
            workers[i] = this.relationshipVsRelationshipChecker(nodeIdRange, direction, relationshipStore, threadQueues[i], end, i);
        }
        workers[workers.length - 1] = () -> {
            RelationshipRecord relationship = (RelationshipRecord)relationshipStore.newRecord();
            try (PageCursorTracer cursorTracer = this.context.pageCacheTracer.createPageCursorTracer(RELATIONSHIP_CONSISTENCY_CHECKER_TAG);
                 PageCursor cursor = relationshipStore.openPageCursorForReadingWithPrefetching(0L, cursorTracer);){
                int recordsPerPage = relationshipStore.getRecordsPerPage();
                long id = direction.startingId(highId);
                while (id >= 0L && id < highId && !this.context.isCancelled()) {
                    for (int i = 0; i < recordsPerPage && id >= 0L && id < highId; ++i) {
                        relationshipStore.getRecordByCursor(id, (AbstractBaseRecord)relationship, RecordLoad.FORCE, cursor);
                        localProgress.add(1L);
                        if (relationship.inUse()) {
                            this.queueRelationshipCheck(threadQueues, threadBatches, relationship);
                        }
                        id = direction.nextId(id);
                    }
                }
                this.processLastRelationshipChecks(threadQueues, threadBatches, end);
                localProgress.done();
            }
        };
        Stopwatch stopwatch = Stopwatch.start();
        this.cacheAccess.clearCache();
        this.context.execution.runAll(this.getClass().getSimpleName() + "-" + direction.name(), workers);
        this.detectSingleRelationshipChainInconsistencies(nodeIdRange);
        this.context.paddedDebug("%s %s took %s", new Object[]{this, direction, Format.duration((long)stopwatch.elapsed(TimeUnit.MILLISECONDS))});
    }

    @Override
    public boolean shouldBeChecked(ConsistencyFlags flags) {
        return flags.isCheckGraph();
    }

    private void detectSingleRelationshipChainInconsistencies(LongRange nodeIdRange) {
        CacheAccess.Client client = this.cacheAccess.client();
        try (PageCursorTracer cursorTracer = this.context.pageCacheTracer.createPageCursorTracer(SINGLE_RELATIONSHIP_CONSISTENCY_CHECKER_TAG);){
            for (long nodeId = nodeIdRange.from(); nodeId < nodeIdRange.to(); ++nodeId) {
                boolean inUse = client.getBooleanFromCache(nodeId, 4);
                boolean hasMultipleRelationships = client.getBooleanFromCache(nodeId, 5);
                if (!inUse || hasMultipleRelationships) continue;
                long reference = client.getFromCache(nodeId, 1);
                long relationshipId = client.getFromCache(nodeId, 0);
                long sourceOrTarget = client.getFromCache(nodeId, 2);
                long prevOrNext = client.getFromCache(nodeId, 3);
                boolean isFirstInChain = client.getBooleanFromCache(nodeId, 6);
                boolean consistent = prevOrNext == 0L ? reference == 1L && isFirstInChain : Record.NULL_REFERENCE.is(reference);
                if (consistent) continue;
                RelationshipStore relationshipStore = this.context.neoStores.getRelationshipStore();
                RelationshipRecord relationship = (RelationshipRecord)relationshipStore.getRecord(relationshipId, (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.FORCE, cursorTracer);
                RelationshipRecord referenceRelationship = (RelationshipRecord)relationshipStore.getRecord(reference, (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.FORCE, cursorTracer);
                RelationshipChainChecker.linkOf(sourceOrTarget == 0L, prevOrNext == 0L).reportDoesNotReferenceBack(this.reporter, relationship, referenceRelationship);
            }
        }
    }

    private static RelationshipLink linkOf(boolean source, boolean prev) {
        if (source) {
            return prev ? RelationshipLink.SOURCE_PREV : RelationshipLink.SOURCE_NEXT;
        }
        return prev ? RelationshipLink.TARGET_PREV : RelationshipLink.TARGET_NEXT;
    }

    private ParallelExecution.ThrowingRunnable relationshipVsRelationshipChecker(LongRange nodeIdRange, ScanDirection direction, RelationshipStore store, ArrayBlockingQueue<BatchedRelationshipRecords> queue, AtomicBoolean end, int threadId) {
        RelationshipRecord relationship = (RelationshipRecord)store.newRecord();
        RelationshipRecord otherRelationship = (RelationshipRecord)store.newRecord();
        CacheAccess.Client client = this.cacheAccess.client();
        RelationshipLink sourceCachePointer = direction.sourceLink;
        RelationshipLink targetCachePointer = direction.targetLink;
        long prevOrNext = direction.cacheSlot;
        return () -> {
            try (PageCursorTracer cursorTracer = this.context.pageCacheTracer.createPageCursorTracer(RELATIONSHIP_CONSISTENCY_CHECKER_TAG);
                 PageCursor otherRelationshipCursor = store.openPageCursorForReading(0L, cursorTracer);){
                while (!(end.get() && queue.isEmpty() || this.context.isCancelled())) {
                    BatchedRelationshipRecords batch = (BatchedRelationshipRecords)queue.poll(100L, TimeUnit.MILLISECONDS);
                    if (batch == null) continue;
                    while (batch.fillNext(relationship) && !this.context.isCancelled()) {
                        long link;
                        boolean wasInUse;
                        boolean processEndNode;
                        long firstNode = relationship.getFirstNode();
                        long secondNode = relationship.getSecondNode();
                        boolean processStartNode = Math.abs(firstNode % (long)this.numberOfChainCheckers) == (long)threadId && nodeIdRange.isWithinRangeExclusiveTo(firstNode);
                        boolean bl = processEndNode = Math.abs(secondNode % (long)this.numberOfChainCheckers) == (long)threadId && nodeIdRange.isWithinRangeExclusiveTo(secondNode);
                        if (processStartNode) {
                            this.checkRelationshipLink(direction, RelationshipLink.SOURCE_PREV, relationship, client, otherRelationship, otherRelationshipCursor, store, cursorTracer);
                            this.checkRelationshipLink(direction, RelationshipLink.SOURCE_NEXT, relationship, client, otherRelationship, otherRelationshipCursor, store, cursorTracer);
                        }
                        if (processEndNode) {
                            this.checkRelationshipLink(direction, RelationshipLink.TARGET_PREV, relationship, client, otherRelationship, otherRelationshipCursor, store, cursorTracer);
                            this.checkRelationshipLink(direction, RelationshipLink.TARGET_NEXT, relationship, client, otherRelationship, otherRelationshipCursor, store, cursorTracer);
                        }
                        if (processStartNode) {
                            wasInUse = client.getBooleanFromCache(firstNode, 4);
                            link = sourceCachePointer.link(relationship);
                            if (link < Record.NULL_REFERENCE.longValue()) {
                                sourceCachePointer.reportDoesNotReferenceBack(this.reporter, relationship, otherRelationship);
                            } else {
                                client.putToCache(firstNode, relationship.getId(), link, 0L, prevOrNext, 1L, CacheSlots.longOf(wasInUse), CacheSlots.longOf(relationship.isFirstInFirstChain()));
                            }
                        }
                        if (!processEndNode) continue;
                        wasInUse = client.getBooleanFromCache(secondNode, 4);
                        link = targetCachePointer.link(relationship);
                        if (link < Record.NULL_REFERENCE.longValue()) {
                            targetCachePointer.reportDoesNotReferenceBack(this.reporter, relationship, otherRelationship);
                            continue;
                        }
                        client.putToCache(secondNode, relationship.getId(), link, -1L, prevOrNext, 1L, CacheSlots.longOf(wasInUse), CacheSlots.longOf(relationship.isFirstInSecondChain()));
                    }
                }
            }
        };
    }

    private void checkRelationshipLink(ScanDirection direction, RelationshipLink link, RelationshipRecord relationshipCursor, CacheAccess.Client client, RelationshipRecord otherRelationship, PageCursor otherRelationshipCursor, RelationshipStore store, PageCursorTracer cursorTracer) {
        long relationshipId = relationshipCursor.getId();
        long nodeId = link.node(relationshipCursor);
        long linkId = link.link(relationshipCursor);
        long fromCache = client.getFromCache(nodeId, 0);
        boolean cachedLinkInUse = client.getBooleanFromCache(nodeId, 4);
        if (!link.endOfChain(relationshipCursor) && cachedLinkInUse) {
            if (fromCache != linkId) {
                if (direction.exclude(relationshipId, linkId)) {
                    return;
                }
                if (!Record.NULL_REFERENCE.is(fromCache)) {
                    store.getRecordByCursor(linkId, (AbstractBaseRecord)otherRelationship, RecordLoad.FORCE, otherRelationshipCursor);
                } else {
                    otherRelationship.clear();
                    link.reportDoesNotReferenceBack(this.reporter, this.recordLoader.relationship(relationshipCursor.getId(), cursorTracer), otherRelationship);
                }
            } else {
                otherRelationship.clear();
                otherRelationship.setId(linkId);
                long other = client.getFromCache(nodeId, 1);
                NodeLink nodeLink = client.getFromCache(nodeId, 2) == 0L ? NodeLink.SOURCE : NodeLink.TARGET;
                nodeLink.setNode(otherRelationship, nodeId);
                link.setOther(otherRelationship, nodeLink, other);
                otherRelationship.setInUse(client.getBooleanFromCache(nodeId, 4));
                otherRelationship.setCreated();
            }
            this.checkRelationshipLink(direction, link, otherRelationship, relationshipId, nodeId, linkId, cursorTracer);
        }
    }

    private void checkRelationshipLink(ScanDirection direction, RelationshipLink thing, RelationshipRecord otherRelationship, long relationshipId, long nodeId, long linkId, PageCursorTracer cursorTracer) {
        NodeLink nodeLink = NodeLink.select(otherRelationship, nodeId);
        if (nodeLink == null) {
            thing.reportOtherNode(this.reporter, this.recordLoader.relationship(relationshipId, cursorTracer), this.recordLoader.relationship(linkId, cursorTracer));
        } else if (thing.other(otherRelationship, nodeLink) != relationshipId) {
            if (otherRelationship.isCreated()) {
                this.recordLoader.relationship(otherRelationship, otherRelationship.getId(), cursorTracer);
                this.checkRelationshipLink(direction, thing, otherRelationship, relationshipId, nodeId, linkId, cursorTracer);
                return;
            }
            thing.reportDoesNotReferenceBack(this.reporter, this.recordLoader.relationship(relationshipId, cursorTracer), this.recordLoader.relationship(linkId, cursorTracer));
        } else if (!direction.exclude(relationshipId, linkId) && !otherRelationship.inUse()) {
            thing.reportNotUsedRelationshipReferencedInChain(this.reporter, this.recordLoader.relationship(relationshipId, cursorTracer), this.recordLoader.relationship(linkId, cursorTracer));
        }
    }

    private void queueRelationshipCheck(ArrayBlockingQueue<BatchedRelationshipRecords>[] threadQueues, BatchedRelationshipRecords[] threadBatches, RelationshipRecord relationshipCursor) throws InterruptedException {
        int sourceThread = (int)Math.abs(relationshipCursor.getFirstNode() % (long)this.numberOfChainCheckers);
        this.queueRelationshipCheck(threadQueues, threadBatches, relationshipCursor, sourceThread);
        int targetThread = (int)Math.abs(relationshipCursor.getSecondNode() % (long)this.numberOfChainCheckers);
        if (targetThread != sourceThread) {
            this.queueRelationshipCheck(threadQueues, threadBatches, relationshipCursor, targetThread);
        }
    }

    private void queueRelationshipCheck(ArrayBlockingQueue<BatchedRelationshipRecords>[] threadQueues, BatchedRelationshipRecords[] threadBatches, RelationshipRecord relationshipCursor, int thread) throws InterruptedException {
        if (!threadBatches[thread].hasMoreSpace()) {
            threadQueues[thread].put(threadBatches[thread]);
            threadBatches[thread] = new BatchedRelationshipRecords();
        }
        threadBatches[thread].add(relationshipCursor);
    }

    private void processLastRelationshipChecks(ArrayBlockingQueue<BatchedRelationshipRecords>[] threadQueues, BatchedRelationshipRecords[] threadBatches, AtomicBoolean end) throws Exception {
        for (int i = 0; i < threadBatches.length; ++i) {
            if (threadBatches[i].numberOfRelationships() <= 0) continue;
            threadQueues[i].put(threadBatches[i]);
        }
        end.set(true);
    }

    public String toString() {
        return String.format("%s[highId:%d]", this.getClass().getSimpleName(), this.context.neoStores.getRelationshipStore().getHighId());
    }

    private static enum ScanDirection {
        FORWARD(RelationshipLink.SOURCE_PREV, RelationshipLink.TARGET_PREV, 0L){

            @Override
            boolean exclude(long id, long reference) {
                return !Record.NULL_REFERENCE.is(reference) && reference > id;
            }

            @Override
            long nextId(long id) {
                return id + 1L;
            }

            @Override
            long startingId(long highId) {
                return 0L;
            }
        }
        ,
        BACKWARD(RelationshipLink.SOURCE_NEXT, RelationshipLink.TARGET_NEXT, -1L){

            @Override
            boolean exclude(long id, long reference) {
                return !Record.NULL_REFERENCE.is(reference) && reference < id;
            }

            @Override
            long nextId(long id) {
                return id - 1L;
            }

            @Override
            long startingId(long highId) {
                return highId - 1L;
            }
        };

        final RelationshipLink sourceLink;
        final RelationshipLink targetLink;
        final long cacheSlot;

        private ScanDirection(RelationshipLink sourceLink, RelationshipLink targetLink, long cacheSlot) {
            this.sourceLink = sourceLink;
            this.targetLink = targetLink;
            this.cacheSlot = cacheSlot;
        }

        abstract boolean exclude(long var1, long var3);

        abstract long nextId(long var1);

        abstract long startingId(long var1);
    }
}

