/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.newchecker.Checker;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.CountsState;
import org.neo4j.consistency.newchecker.EntityTokenIndexCheckState;
import org.neo4j.consistency.newchecker.NodeChecker;
import org.neo4j.consistency.newchecker.ParallelExecution;
import org.neo4j.consistency.newchecker.RecordLoading;
import org.neo4j.consistency.newchecker.SafePropertyChainReader;
import org.neo4j.consistency.newchecker.SchemaComplianceChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.synthetic.TokenScanDocument;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.index.label.AllEntriesTokenScanReader;
import org.neo4j.internal.index.label.EntityTokenRange;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.RelationshipCounter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;

class RelationshipChecker
implements Checker {
    private static final String UNUSED_RELATIONSHIP_CHECKER_TAG = "unusedRelationshipChecker";
    private static final String RELATIONSHIP_RANGE_CHECKER_TAG = "relationshipRangeChecker";
    private final NeoStores neoStores;
    private final ParallelExecution execution;
    private final ConsistencyReport.Reporter reporter;
    private final CacheAccess cacheAccess;
    private final TokenHolders tokenHolders;
    private final RecordLoading recordLoader;
    private final CountsState observedCounts;
    private final CheckerContext context;
    private final MutableIntObjectMap<MutableIntSet> mandatoryProperties;
    private final List<IndexDescriptor> indexes;
    private final ProgressListener progress;
    private final RelationshipTypeScanStore relationshipTypeScanStore;

    RelationshipChecker(CheckerContext context, MutableIntObjectMap<MutableIntSet> mandatoryProperties) {
        this.context = context;
        this.neoStores = context.neoStores;
        this.execution = context.execution;
        this.reporter = context.reporter;
        this.cacheAccess = context.cacheAccess;
        this.tokenHolders = context.tokenHolders;
        this.recordLoader = context.recordLoader;
        this.observedCounts = context.observedCounts;
        this.mandatoryProperties = mandatoryProperties;
        this.indexes = context.indexAccessors.onlineRules(EntityType.RELATIONSHIP);
        this.progress = context.progressReporter(this, "Relationships", this.neoStores.getRelationshipStore().getHighId());
        this.relationshipTypeScanStore = context.relationshipTypeScanStore;
    }

    @Override
    public boolean shouldBeChecked(ConsistencyFlags flags) {
        return flags.isCheckGraph() || !this.indexes.isEmpty() && flags.isCheckIndexes() || flags.isCheckRelationshipTypeScanStore();
    }

    @Override
    public void check(LongRange nodeIdRange, boolean firstRange, boolean lastRange) throws Exception {
        this.execution.run(this.getClass().getSimpleName() + "-relationships", this.execution.partition((RecordStore<?>)this.neoStores.getRelationshipStore(), (from, to, last) -> () -> this.check(nodeIdRange, firstRange, from, to, lastRange && last)));
        this.execution.run(this.getClass().getSimpleName() + "-unusedRelationships", this.execution.partition(nodeIdRange, (from, to, last) -> () -> this.checkNodesReferencingUnusedRelationships(from, to, this.context.pageCacheTracer)));
    }

    private void check(LongRange nodeIdRange, boolean firstRound, long fromRelationshipId, long toRelationshipId, boolean last) throws Exception {
        RelationshipCounter counter = this.observedCounts.instantiateRelationshipCounter();
        long[] typeHolder = new long[1];
        try (RecordStorageReader reader = new RecordStorageReader(this.neoStores);
             PageCursorTracer cursorTracer = this.context.pageCacheTracer.createPageCursorTracer(RELATIONSHIP_RANGE_CHECKER_TAG);
             RecordRelationshipScanCursor relationshipCursor = reader.allocateRelationshipScanCursor(cursorTracer);
             AllEntriesTokenScanReader relationshipTypeReader = this.relationshipTypeScanStore.allEntityTokenRanges(fromRelationshipId, last ? Long.MAX_VALUE : toRelationshipId, cursorTracer);
             SafePropertyChainReader property = new SafePropertyChainReader(this.context, cursorTracer);
             SchemaComplianceChecker schemaComplianceChecker = new SchemaComplianceChecker(this.context, this.mandatoryProperties, this.indexes, cursorTracer, this.context.memoryTracker);){
            ProgressListener localProgress = this.progress.threadLocalReporter();
            CacheAccess.Client client = this.cacheAccess.client();
            IntObjectHashMap propertyValues = new IntObjectHashMap();
            Iterator relationshipTypeRangeIterator = relationshipTypeReader.iterator();
            EntityTokenIndexCheckState typeIndexState = new EntityTokenIndexCheckState(null, fromRelationshipId - 1L);
            for (long relationshipId = fromRelationshipId; relationshipId < toRelationshipId && !this.context.isCancelled(); ++relationshipId) {
                boolean endNodeIsNegativeOnFirstRound;
                boolean startNodeIsNegativeOnFirstRound;
                localProgress.add(1L);
                relationshipCursor.single(relationshipId);
                relationshipCursor.setForceLoad();
                if (!relationshipCursor.next()) continue;
                long startNode = relationshipCursor.getFirstNode();
                boolean startNodeIsWithinRange = nodeIdRange.isWithinRangeExclusiveTo(startNode);
                boolean bl = startNodeIsNegativeOnFirstRound = startNode < 0L && firstRound;
                if (startNodeIsWithinRange || startNodeIsNegativeOnFirstRound) {
                    this.checkRelationshipVsNode(client, relationshipCursor, startNode, relationshipCursor.isFirstInFirstChain(), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).sourceNodeNotInUse((NodeRecord)node), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).sourceNodeDoesNotReferenceBack((NodeRecord)node), (relationship, node) -> this.reporter.forNode((NodeRecord)node).relationshipNotFirstInSourceChain((RelationshipRecord)relationship), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).sourceNodeHasNoRelationships((NodeRecord)node), relationship -> this.reporter.forRelationship((RelationshipRecord)relationship).illegalSourceNode(), cursorTracer);
                }
                long endNode = relationshipCursor.getSecondNode();
                boolean endNodeIsWithinRange = nodeIdRange.isWithinRangeExclusiveTo(endNode);
                boolean bl2 = endNodeIsNegativeOnFirstRound = endNode < 0L && firstRound;
                if (endNodeIsWithinRange || endNodeIsNegativeOnFirstRound) {
                    this.checkRelationshipVsNode(client, relationshipCursor, endNode, relationshipCursor.isFirstInSecondChain(), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).targetNodeNotInUse((NodeRecord)node), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).targetNodeDoesNotReferenceBack((NodeRecord)node), (relationship, node) -> this.reporter.forNode((NodeRecord)node).relationshipNotFirstInTargetChain((RelationshipRecord)relationship), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).targetNodeHasNoRelationships((NodeRecord)node), relationship -> this.reporter.forRelationship((RelationshipRecord)relationship).illegalTargetNode(), cursorTracer);
                }
                if (firstRound) {
                    if (startNode >= this.context.highNodeId) {
                        this.reporter.forRelationship((RelationshipRecord)relationshipCursor).sourceNodeNotInUse(this.context.recordLoader.node(startNode, cursorTracer));
                    }
                    if (endNode >= this.context.highNodeId) {
                        this.reporter.forRelationship((RelationshipRecord)relationshipCursor).targetNodeNotInUse(this.context.recordLoader.node(endNode, cursorTracer));
                    }
                    typeHolder[0] = relationshipCursor.getType();
                    RecordLoading.lightClear(propertyValues);
                    boolean propertyChainIsOk = property.read((MutableIntObjectMap<Value>)propertyValues, relationshipCursor, this.reporter::forRelationship, cursorTracer);
                    if (propertyChainIsOk) {
                        schemaComplianceChecker.checkContainsMandatoryProperties(relationshipCursor, typeHolder, (IntObjectMap<Value>)propertyValues, this.reporter::forRelationship);
                        if (this.context.consistencyFlags.isCheckIndexes()) {
                            schemaComplianceChecker.checkCorrectlyIndexed(relationshipCursor, typeHolder, (IntObjectMap<Value>)propertyValues, this.reporter::forRelationship);
                        }
                    }
                    RecordLoading.checkValidToken(relationshipCursor, relationshipCursor.type(), this.tokenHolders.relationshipTypeTokens(), this.neoStores.getRelationshipTypeTokenStore(), (rel, token) -> this.reporter.forRelationship((RelationshipRecord)rel).illegalRelationshipType(), (rel, token) -> this.reporter.forRelationship((RelationshipRecord)rel).relationshipTypeNotInUse((RelationshipTypeTokenRecord)token), cursorTracer);
                    this.observedCounts.incrementRelationshipTypeCounts(counter, (RelationshipRecord)relationshipCursor);
                    if (this.context.consistencyFlags.isCheckRelationshipTypeScanStore()) {
                        this.checkRelationshipVsRelationshipTypeIndex(relationshipCursor, relationshipTypeRangeIterator, typeIndexState, relationshipId, relationshipCursor.type(), fromRelationshipId, cursorTracer);
                    }
                }
                this.observedCounts.incrementRelationshipNodeCounts(counter, (RelationshipRecord)relationshipCursor, startNodeIsWithinRange, endNodeIsWithinRange);
            }
            if (!this.context.isCancelled() && this.context.consistencyFlags.isCheckRelationshipTypeScanStore()) {
                this.reportRemainingRelationshipTypeIndexEntries(relationshipTypeRangeIterator, typeIndexState, last ? Long.MAX_VALUE : toRelationshipId, cursorTracer);
            }
            localProgress.done();
        }
    }

    private void checkRelationshipVsRelationshipTypeIndex(RecordRelationshipScanCursor relationshipCursor, Iterator<EntityTokenRange> relationshipTypeRangeIterator, EntityTokenIndexCheckState relationshipTypeIndexState, long relationshipId, int type, long fromRelationshipId, PageCursorTracer cursorTracer) {
        long relationshipIdMissingFromStore;
        while (relationshipTypeIndexState.needToMoveRangeForwardToReachEntity(relationshipId) && !this.context.isCancelled() && relationshipTypeRangeIterator.hasNext()) {
            if (relationshipTypeIndexState.currentRange != null) {
                for (relationshipIdMissingFromStore = relationshipTypeIndexState.lastCheckedEntityId + 1L; relationshipIdMissingFromStore < relationshipId && relationshipTypeIndexState.currentRange.covers(relationshipIdMissingFromStore); ++relationshipIdMissingFromStore) {
                    if (relationshipTypeIndexState.currentRange.tokens(relationshipIdMissingFromStore).length <= 0) continue;
                    this.reporter.forRelationshipTypeScan(new TokenScanDocument(relationshipTypeIndexState.currentRange)).relationshipNotInUse(this.recordLoader.relationship(relationshipIdMissingFromStore, cursorTracer));
                }
            }
            relationshipTypeIndexState.currentRange = relationshipTypeRangeIterator.next();
            relationshipTypeIndexState.lastCheckedEntityId = Math.max(fromRelationshipId, relationshipTypeIndexState.currentRange.entities()[0]) - 1L;
        }
        if (relationshipTypeIndexState.currentRange != null && relationshipTypeIndexState.currentRange.covers(relationshipId)) {
            for (relationshipIdMissingFromStore = relationshipTypeIndexState.lastCheckedEntityId + 1L; relationshipIdMissingFromStore < relationshipId; ++relationshipIdMissingFromStore) {
                if (relationshipTypeIndexState.currentRange.tokens(relationshipIdMissingFromStore).length <= 0) continue;
                this.reporter.forRelationshipTypeScan(new TokenScanDocument(relationshipTypeIndexState.currentRange)).relationshipNotInUse(this.recordLoader.relationship(relationshipIdMissingFromStore, cursorTracer));
            }
            long[] relationshipTypesInTypeIndex = relationshipTypeIndexState.currentRange.tokens(relationshipId);
            this.validateTypeIds(relationshipCursor, type, relationshipTypesInTypeIndex, relationshipTypeIndexState.currentRange, cursorTracer);
            relationshipTypeIndexState.lastCheckedEntityId = relationshipId;
        } else {
            TokenScanDocument document = new TokenScanDocument(new EntityTokenRange(relationshipId / 64L, EntityTokenRange.NO_TOKENS, EntityType.RELATIONSHIP));
            this.reporter.forRelationshipTypeScan(document).relationshipTypeNotInIndex(this.recordLoader.relationship(relationshipId, cursorTracer), type);
        }
    }

    private void reportRemainingRelationshipTypeIndexEntries(Iterator<EntityTokenRange> relationshipTypeRangeIterator, EntityTokenIndexCheckState relationshipTypeIndexState, long toRelationshipId, PageCursorTracer cursorTracer) {
        if (relationshipTypeIndexState.currentRange == null && relationshipTypeRangeIterator.hasNext()) {
            relationshipTypeIndexState.currentRange = relationshipTypeRangeIterator.next();
        }
        while (relationshipTypeIndexState.currentRange != null && !this.context.isCancelled()) {
            long relationshipIdMissingFromStore = relationshipTypeIndexState.lastCheckedEntityId + 1L;
            while (relationshipIdMissingFromStore < toRelationshipId && !relationshipTypeIndexState.needToMoveRangeForwardToReachEntity(relationshipIdMissingFromStore)) {
                if (relationshipTypeIndexState.currentRange.covers(relationshipIdMissingFromStore) && relationshipTypeIndexState.currentRange.tokens(relationshipIdMissingFromStore).length > 0) {
                    this.reporter.forRelationshipTypeScan(new TokenScanDocument(relationshipTypeIndexState.currentRange)).relationshipNotInUse(this.recordLoader.relationship(relationshipIdMissingFromStore, cursorTracer));
                }
                relationshipTypeIndexState.lastCheckedEntityId = relationshipIdMissingFromStore++;
            }
            relationshipTypeIndexState.currentRange = relationshipTypeRangeIterator.hasNext() ? relationshipTypeRangeIterator.next() : null;
        }
    }

    private void validateTypeIds(RecordRelationshipScanCursor relationshipCursor, int typeInStore, long[] relationshipTypesInTypeIndex, EntityTokenRange entityTokenRange, PageCursorTracer cursorTracer) {
        NodeChecker.compareTwoSortedLongArrays(PropertySchemaType.COMPLETE_ALL_TOKENS, new long[]{typeInStore}, relationshipTypesInTypeIndex, indexType -> this.reporter.forRelationshipTypeScan(new TokenScanDocument(entityTokenRange)).relationshipDoesNotHaveExpectedRelationshipType(this.recordLoader.relationship(relationshipCursor.getId(), cursorTracer), indexType), storeType -> this.reporter.forRelationshipTypeScan(new TokenScanDocument(entityTokenRange)).relationshipTypeNotInIndex(this.recordLoader.relationship(relationshipCursor.getId(), cursorTracer), storeType));
    }

    private void checkRelationshipVsNode(CacheAccess.Client client, RecordRelationshipScanCursor relationshipCursor, long node, boolean firstInChain, BiConsumer<RelationshipRecord, NodeRecord> reportNodeNotInUse, BiConsumer<RelationshipRecord, NodeRecord> reportNodeDoesNotReferenceBack, BiConsumer<RelationshipRecord, NodeRecord> reportNodeNotFirstInChain, BiConsumer<RelationshipRecord, NodeRecord> reportNodeHasNoChain, Consumer<RelationshipRecord> reportIllegalNode, PageCursorTracer cursorTracer) {
        if (node < 0L) {
            reportIllegalNode.accept(this.recordLoader.relationship(relationshipCursor.getId(), cursorTracer));
            return;
        }
        boolean nodeInUse = client.getBooleanFromCache(node, 2);
        if (!nodeInUse) {
            reportNodeNotInUse.accept(this.recordLoader.relationship(relationshipCursor.getId(), cursorTracer), this.recordLoader.node(node, cursorTracer));
            return;
        }
        long nodeNextRel = client.getFromCache(node, 0);
        if (Record.NULL_REFERENCE.is(nodeNextRel)) {
            reportNodeHasNoChain.accept(this.recordLoader.relationship(relationshipCursor.getId(), cursorTracer), this.recordLoader.node(node, cursorTracer));
            return;
        }
        boolean nodeIsDense = client.getBooleanFromCache(node, 3);
        if (!nodeIsDense) {
            if (firstInChain) {
                if (nodeNextRel != relationshipCursor.getId()) {
                    reportNodeDoesNotReferenceBack.accept(this.recordLoader.relationship(relationshipCursor.getId(), cursorTracer), this.recordLoader.node(node, cursorTracer));
                    RelationshipRecord relationshipThatNodeActuallyReferences = this.recordLoader.relationship(nodeNextRel, cursorTracer);
                    if (!relationshipThatNodeActuallyReferences.inUse()) {
                        this.reporter.forNode(this.recordLoader.node(node, cursorTracer)).relationshipNotInUse(relationshipThatNodeActuallyReferences);
                    } else if (relationshipThatNodeActuallyReferences.getFirstNode() != node && relationshipThatNodeActuallyReferences.getSecondNode() != node) {
                        this.reporter.forNode(this.recordLoader.node(node, cursorTracer)).relationshipForOtherNode(relationshipThatNodeActuallyReferences);
                    }
                }
                client.putToCacheSingle(node, 5, 0L);
            }
            if (!firstInChain && nodeNextRel == relationshipCursor.getId()) {
                reportNodeNotFirstInChain.accept(this.recordLoader.relationship(relationshipCursor.getId(), cursorTracer), this.recordLoader.node(node, cursorTracer));
            }
        }
    }

    private void checkNodesReferencingUnusedRelationships(long fromNodeId, long toNodeId, PageCacheTracer pageCacheTracer) {
        CacheAccess.Client client = this.cacheAccess.client();
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(UNUSED_RELATIONSHIP_CHECKER_TAG);){
            for (long id = fromNodeId; id < toNodeId && !this.context.isCancelled(); ++id) {
                boolean needsChecking;
                boolean nodeInUse = client.getBooleanFromCache(id, 2);
                if (!nodeInUse || !(needsChecking = client.getBooleanFromCache(id, 5))) continue;
                long nodeNextRel = client.getFromCache(id, 0);
                boolean nodeIsDense = client.getBooleanFromCache(id, 3);
                if (Record.NULL_REFERENCE.is(nodeNextRel)) continue;
                if (!nodeIsDense) {
                    RelationshipRecord relationship = this.recordLoader.relationship(nodeNextRel, cursorTracer);
                    NodeRecord node = this.recordLoader.node(id, cursorTracer);
                    if (!relationship.inUse()) {
                        this.reporter.forNode(node).relationshipNotInUse(relationship);
                        continue;
                    }
                    this.reporter.forNode(node).relationshipForOtherNode(relationship);
                    continue;
                }
                RelationshipGroupRecord group = this.recordLoader.relationshipGroup(nodeNextRel, cursorTracer);
                if (!group.inUse()) {
                    this.reporter.forNode(this.recordLoader.node(id, cursorTracer)).relationshipGroupNotInUse(group);
                    continue;
                }
                this.reporter.forNode(this.recordLoader.node(id, cursorTracer)).relationshipGroupHasOtherOwner(group);
            }
        }
    }

    public String toString() {
        return String.format("%s[highId:%d,indexesToCheck:%d]", this.getClass().getSimpleName(), this.neoStores.getRelationshipStore().getHighId(), this.indexes.size());
    }
}

