/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import org.neo4j.consistency.store.DelegatingRecordAccess;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class CacheSmallStoresRecordAccess
extends DelegatingRecordAccess {
    private final PropertyKeyTokenRecord[] propertyKeys;
    private final RelationshipTypeTokenRecord[] relationshipTypes;
    private final LabelTokenRecord[] labels;

    public CacheSmallStoresRecordAccess(RecordAccess delegate, PropertyKeyTokenRecord[] propertyKeys, RelationshipTypeTokenRecord[] relationshipTypes, LabelTokenRecord[] labels) {
        super(delegate);
        this.propertyKeys = propertyKeys;
        this.relationshipTypes = relationshipTypes;
        this.labels = labels;
    }

    @Override
    public RecordReference<RelationshipTypeTokenRecord> relationshipType(int id, PageCursorTracer cursorTracer) {
        if (id < this.relationshipTypes.length) {
            return new DirectRecordReference<RelationshipTypeTokenRecord>(this.relationshipTypes[id], this, cursorTracer);
        }
        return super.relationshipType(id, cursorTracer);
    }

    @Override
    public RecordReference<PropertyKeyTokenRecord> propertyKey(int id, PageCursorTracer cursorTracer) {
        if (id < this.propertyKeys.length) {
            return new DirectRecordReference<PropertyKeyTokenRecord>(this.propertyKeys[id], this, cursorTracer);
        }
        return super.propertyKey(id, cursorTracer);
    }

    @Override
    public RecordReference<LabelTokenRecord> label(int id, PageCursorTracer cursorTracer) {
        if (id < this.labels.length) {
            return new DirectRecordReference<LabelTokenRecord>(this.labels[id], this, cursorTracer);
        }
        return super.label(id, cursorTracer);
    }
}

