/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.repr.Serializer;

public class DiscoverableURIs {
    private final Map<String, URITemplate> entries;

    private DiscoverableURIs(Map<String, URITemplate> entries) {
        this.entries = entries;
    }

    public void forEach(BiConsumer<String, String> consumer) {
        this.entries.forEach((? super K key, ? super V value) -> consumer.accept((String)key, value.uriString()));
    }

    public DiscoverableURIs update(URI baseUri) {
        this.entries.forEach((? super K key, ? super V value) -> value.update(baseUri));
        return this;
    }

    public static class Builder {
        private Map<String, URITemplate> entries = new HashMap<String, URITemplate>();

        public Builder addEndpoint(String key, String endpoint) {
            RelativePathBasedURITemplate path = new RelativePathBasedURITemplate(endpoint);
            this.entries.put(key, path);
            return this;
        }

        public Builder addBoltEndpoint(Config config, ConnectorPortRegister portRegister) {
            if (!((Boolean)config.get(BoltConnector.enabled)).booleanValue()) {
                return this;
            }
            this.addBoltEndpoint("bolt_direct", "bolt", ServerSettings.bolt_discoverable_address, config, portRegister);
            this.addBoltEndpoint("bolt_routing", "neo4j", ServerSettings.bolt_routing_discoverable_address, config, portRegister);
            return this;
        }

        public DiscoverableURIs build() {
            return new DiscoverableURIs(this.entries);
        }

        private void addBoltEndpoint(String key, String scheme, Setting<URI> override, Config config, ConnectorPortRegister portRegister) {
            URIBasedURITemplate path;
            if (config.isExplicitlySet(override)) {
                URI uri = (URI)config.get(override);
                path = new URIBasedURITemplate(uri, false);
            } else {
                SocketAddress address = (SocketAddress)config.get(BoltConnector.advertised_address);
                int port = address.getPort() == 0 ? portRegister.getLocalAddress("bolt").getPort() : address.getPort();
                String host = address.getHostname();
                path = new URIBasedURITemplate(URI.create(String.format("%s://%s:%s", scheme, host, port)), !this.isBoltHostNameExplicitlySet(config));
            }
            this.entries.put(key, path);
        }

        private boolean isBoltHostNameExplicitlySet(Config config) {
            if (config.isExplicitlySet(GraphDatabaseSettings.default_advertised_address)) {
                return true;
            }
            if (config.isExplicitlySet(BoltConnector.advertised_address)) {
                SocketAddress defaultAddress = (SocketAddress)config.get(GraphDatabaseSettings.default_advertised_address);
                SocketAddress boltAddress = (SocketAddress)config.get(BoltConnector.advertised_address);
                return !boltAddress.getHostname().equals(defaultAddress.getHostname());
            }
            return false;
        }
    }

    private static class URIBasedURITemplate
    implements URITemplate {
        private URI uri;
        private final boolean isHostOverridable;

        private URIBasedURITemplate(URI uri, boolean isHostOverridable) {
            this.uri = uri;
            this.isHostOverridable = isHostOverridable;
        }

        @Override
        public String uriString() {
            return this.uri.toASCIIString();
        }

        @Override
        public void update(URI baseUri) {
            if (this.isHostOverridable) {
                this.uri = URI.create(String.format("%s://%s:%s", this.uri.getScheme(), baseUri.getHost(), this.uri.getPort()));
            }
        }
    }

    private static class RelativePathBasedURITemplate
    implements URITemplate {
        private final String relativePath;
        private String fullPath;

        private RelativePathBasedURITemplate(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public String uriString() {
            return this.fullPath == null ? this.relativePath : this.fullPath;
        }

        @Override
        public void update(URI baseUri) {
            this.fullPath = Serializer.joinBaseWithRelativePath((URI)baseUri, (String)this.relativePath);
        }
    }

    private static interface URITemplate {
        public String uriString();

        public void update(URI var1);
    }
}

