/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.function.Factory;
import org.neo4j.internal.batchimport.cache.idmapping.string.RadixCalculator;

public abstract class Radix {
    public static final Factory<Radix> LONG = Long::new;
    public static final Factory<Radix> STRING = String::new;
    private long nullCount;
    final long[] radixIndexCount = new long[(int)Math.pow(2.0, 23.0)];

    public int registerRadixOf(long value) {
        int radix = this.calculator().radixOf(value);
        if (radix == -1) {
            ++this.nullCount;
        } else {
            int n = radix;
            this.radixIndexCount[n] = this.radixIndexCount[n] + 1L;
        }
        return radix;
    }

    public long getNullCount() {
        return this.nullCount;
    }

    public long[] getRadixIndexCounts() {
        return this.radixIndexCount;
    }

    public abstract RadixCalculator calculator();

    public java.lang.String toString() {
        return Radix.class.getSimpleName() + "." + this.getClass().getSimpleName();
    }

    public static class Long
    extends Radix {
        private final MutableInt radixShift = new MutableInt();
        private final RadixCalculator calculator = new RadixCalculator.Long(this.radixShift);

        @Override
        public RadixCalculator calculator() {
            return this.calculator;
        }

        @Override
        public int registerRadixOf(long value) {
            this.radixOverflow(value);
            return super.registerRadixOf(value);
        }

        private void radixOverflow(long val) {
            long shiftVal = (val & 0x1FFFFFFFFFFFFFFL) >> 23 + this.radixShift.intValue();
            if (shiftVal > 0L) {
                while (shiftVal > 0L) {
                    this.radixShift.increment();
                    this.compressRadixIndex();
                    shiftVal >>= 1;
                }
            }
        }

        private void compressRadixIndex() {
            int i;
            for (i = 0; i < this.radixIndexCount.length / 2; ++i) {
                this.radixIndexCount[i] = this.radixIndexCount[2 * i] + this.radixIndexCount[2 * i + 1];
            }
            for (i = this.radixIndexCount.length / 2; i < this.radixIndexCount.length; ++i) {
                this.radixIndexCount[i] = 0L;
            }
        }
    }

    public static class String
    extends Radix {
        private final RadixCalculator calculator = new RadixCalculator.String();

        @Override
        public RadixCalculator calculator() {
            return this.calculator;
        }
    }
}

