/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.Arrays;

class SameGroupDetector {
    private long[] seen = new long[100];
    private int cursor;

    SameGroupDetector() {
    }

    long collisionWithinSameGroup(long dataIndexA, int groupIdA, long dataIndexB, int groupIdB) {
        if (this.cursor == 0) {
            this.add(dataIndexA, groupIdA);
        }
        long collision = -1L;
        for (int i = 0; i < this.cursor; ++i) {
            long dataIndexAtCursor = this.seen[i++];
            long groupIdAtCursor = this.seen[i];
            if (groupIdAtCursor != (long)groupIdB) continue;
            collision = dataIndexAtCursor;
            break;
        }
        this.add(dataIndexB, groupIdB);
        return collision;
    }

    private void add(long dataIndex, int groupId) {
        if (this.cursor == this.seen.length) {
            this.seen = Arrays.copyOf(this.seen, this.seen.length * 2);
        }
        this.seen[this.cursor++] = dataIndex;
        this.seen[this.cursor++] = groupId;
    }

    void reset() {
        this.cursor = 0;
    }
}

