/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.Serializer;

public class MappingSerializer
extends Serializer {
    final MappingWriter writer;

    MappingSerializer(MappingWriter writer, URI baseUri) {
        super(baseUri);
        this.writer = writer;
    }

    public void putRelativeUri(String key, String path) {
        this.writer.writeValue(RepresentationType.URI, key, (Object)this.relativeUri(path));
    }

    public void putRelativeUriTemplate(String key, String template) {
        this.writer.writeValue(RepresentationType.TEMPLATE, key, (Object)this.relativeTemplate(template));
    }

    public void putString(String key, String value) {
        this.writer.writeString(key, value);
    }

    void putBoolean(String key, boolean value) {
        this.writer.writeBoolean(key, value);
    }

    public void putMapping(String key, MappingRepresentation value) {
        this.serialize(this.writer.newMapping(value.type, key), value);
    }

    public void putList(String key, ListRepresentation value) {
        this.serialize(this.writer.newList(value.type, key), value);
    }

    final void putNumber(String key, Number value) {
        if (value instanceof Double || value instanceof Float) {
            this.writer.writeFloatingPointNumber(RepresentationType.valueOf(value.getClass()), key, value.doubleValue());
        } else {
            this.checkThatItIsBuiltInType(value);
            this.writer.writeInteger(RepresentationType.valueOf(value.getClass()), key, value.longValue());
        }
    }

    public MappingWriter getWriter() {
        return this.writer;
    }
}

