/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import javax.ws.rs.core.MediaType;
import org.neo4j.annotations.service.Service;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.RepresentationType;

@Service
public abstract class RepresentationFormat
implements InputFormat {
    final MediaType mediaType;

    public RepresentationFormat(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.mediaType);
    }

    String serializeValue(RepresentationType type, Object value) {
        return this.serializeValue(type.valueName, value);
    }

    protected abstract String serializeValue(String var1, Object var2);

    ListWriter serializeList(RepresentationType type) {
        if (type.listName == null) {
            throw new IllegalStateException("Invalid list type: " + type);
        }
        return this.serializeList(type.listName);
    }

    protected abstract ListWriter serializeList(String var1);

    MappingWriter serializeMapping(RepresentationType type) {
        return this.serializeMapping(type.valueName);
    }

    protected abstract MappingWriter serializeMapping(String var1);

    protected abstract String complete(ListWriter var1);

    protected abstract String complete(MappingWriter var1);

    public void complete() {
    }
}

