/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.index.label.AddMerger;
import org.neo4j.internal.index.label.NativeTokenScanWriter;
import org.neo4j.internal.index.label.TokenScanKey;
import org.neo4j.internal.index.label.TokenScanValue;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.util.Preconditions;

class BulkAppendNativeTokenScanWriter
implements TokenScanWriter {
    private final Writer<TokenScanKey, TokenScanValue> writer;
    private final ValueMerger<TokenScanKey, TokenScanValue> merger;
    private final MutableIntObjectMap<Pair<TokenScanKey, TokenScanValue>> ranges = IntObjectMaps.mutable.empty();

    BulkAppendNativeTokenScanWriter(Writer<TokenScanKey, TokenScanValue> writer) {
        this.writer = writer;
        this.merger = new AddMerger(NativeTokenScanWriter.EMPTY);
    }

    @Override
    public void write(EntityTokenUpdate update) {
        Preconditions.checkArgument((update.getTokensBefore().length == 0 ? 1 : 0) != 0, (String)"Was expecting no tokens before, was %s", (Object[])new Object[]{Arrays.toString(update.getTokensBefore())});
        long idRange = NativeTokenScanWriter.rangeOf(update.getEntityId());
        int previousTokenId = -1;
        for (long tokenId : update.getTokensAfter()) {
            int intTokenId = Math.toIntExact(tokenId);
            Preconditions.checkArgument((intTokenId > previousTokenId ? 1 : 0) != 0, (String)"Detected unsorted tokens in %s", (Object[])new Object[]{update});
            previousTokenId = intTokenId;
            Pair range = (Pair)this.ranges.getIfAbsentPutWithKey(intTokenId, (IntToObjectFunction & Serializable)id -> Pair.of((Object)new TokenScanKey(id, idRange), (Object)new TokenScanValue()));
            if (((TokenScanKey)range.getKey()).idRange != idRange) {
                if (((TokenScanKey)range.getKey()).idRange != -1L) {
                    this.writer.merge((Object)((TokenScanKey)range.getKey()), (Object)((TokenScanValue)range.getValue()), this.merger);
                }
                ((TokenScanKey)range.getKey()).idRange = idRange;
                ((TokenScanValue)range.getValue()).clear();
            }
            ((TokenScanValue)range.getValue()).set(NativeTokenScanWriter.offsetOf(update.getEntityId()));
        }
    }

    @Override
    public void close() throws IOException {
        try {
            for (Pair range : this.ranges) {
                if (range == null) continue;
                this.writer.merge((Object)((TokenScanKey)range.getKey()), (Object)((TokenScanValue)range.getValue()), this.merger);
            }
        }
        finally {
            this.writer.close();
        }
    }
}

