/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.neo4j.common.EntityType;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.index.label.AllEntriesTokenScanReader;
import org.neo4j.internal.index.label.EntityTokenRange;
import org.neo4j.internal.index.label.TokenScanKey;
import org.neo4j.internal.index.label.TokenScanValue;

class NativeAllEntriesTokenScanReader
implements AllEntriesTokenScanReader {
    private final IntFunction<Seeker<TokenScanKey, TokenScanValue>> seekProvider;
    private final List<Seeker<TokenScanKey, TokenScanValue>> cursors = new ArrayList<Seeker<TokenScanKey, TokenScanValue>>();
    private final int highestTokenId;
    private final EntityType entityType;

    NativeAllEntriesTokenScanReader(IntFunction<Seeker<TokenScanKey, TokenScanValue>> seekProvider, int highestTokenId, EntityType entityType) {
        this.seekProvider = seekProvider;
        this.highestTokenId = highestTokenId;
        this.entityType = entityType;
    }

    public long maxCount() {
        return -1L;
    }

    @Override
    public int rangeSize() {
        return 64;
    }

    public Iterator<EntityTokenRange> iterator() {
        try {
            long lowestRange = Long.MAX_VALUE;
            this.closeCursors();
            for (int tokenId = 0; tokenId <= this.highestTokenId; ++tokenId) {
                Seeker<TokenScanKey, TokenScanValue> cursor = this.seekProvider.apply(tokenId);
                if (!cursor.next()) continue;
                lowestRange = Long.min(lowestRange, ((TokenScanKey)cursor.key()).idRange);
                this.cursors.add(cursor);
            }
            return new EntityTokenRangeIterator(lowestRange, this.entityType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeCursors() throws IOException {
        for (Seeker<TokenScanKey, TokenScanValue> cursor : this.cursors) {
            cursor.close();
        }
        this.cursors.clear();
    }

    public void close() throws Exception {
        this.closeCursors();
    }

    private class EntityTokenRangeIterator
    extends PrefetchingIterator<EntityTokenRange> {
        private long currentRange;
        private final EntityType entityType;
        private final MutableLongList[] tokensForEachEntity = new MutableLongList[64];

        EntityTokenRangeIterator(long lowestRange, EntityType entityType) {
            this.currentRange = lowestRange;
            this.entityType = entityType;
        }

        protected EntityTokenRange fetchNextOrNull() {
            if (this.currentRange == Long.MAX_VALUE) {
                return null;
            }
            Arrays.fill(this.tokensForEachEntity, null);
            long nextLowestRange = Long.MAX_VALUE;
            try {
                for (Seeker<TokenScanKey, TokenScanValue> cursor : NativeAllEntriesTokenScanReader.this.cursors) {
                    long idRange = ((TokenScanKey)cursor.key()).idRange;
                    if (idRange < this.currentRange) {
                        assert (!cursor.next());
                        continue;
                    }
                    if (idRange == this.currentRange) {
                        long bits = ((TokenScanValue)cursor.value()).bits;
                        long tokenId = ((TokenScanKey)cursor.key()).tokenId;
                        EntityTokenRange.readBitmap(bits, tokenId, this.tokensForEachEntity);
                        if (!cursor.next()) continue;
                        nextLowestRange = Long.min(nextLowestRange, ((TokenScanKey)cursor.key()).idRange);
                        continue;
                    }
                    nextLowestRange = Long.min(nextLowestRange, ((TokenScanKey)cursor.key()).idRange);
                }
                EntityTokenRange range = new EntityTokenRange(this.currentRange, EntityTokenRange.convertState((LongList[])this.tokensForEachEntity), this.entityType);
                this.currentRange = nextLowestRange;
                return range;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

