/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.index.label.AddMerger;
import org.neo4j.internal.index.label.PhysicalToLogicalTokenChanges;
import org.neo4j.internal.index.label.TokenScanKey;
import org.neo4j.internal.index.label.TokenScanValue;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.storageengine.api.EntityTokenUpdate;

class NativeTokenScanWriter
implements TokenScanWriter {
    private static final Comparator<EntityTokenUpdate> UPDATE_SORTER = Comparator.comparingLong(EntityTokenUpdate::getEntityId);
    private final ValueMerger<TokenScanKey, TokenScanValue> addMerger;
    private final ValueMerger<TokenScanKey, TokenScanValue> removeMerger;
    private final WriteMonitor monitor;
    private Writer<TokenScanKey, TokenScanValue> writer;
    private final TokenScanKey key = new TokenScanKey();
    private final TokenScanValue value = new TokenScanValue();
    private final EntityTokenUpdate[] pendingUpdates;
    private int pendingUpdatesCursor;
    private boolean addition;
    private long lowestTokenId;
    static final WriteMonitor EMPTY = new WriteMonitor(){};

    NativeTokenScanWriter(int batchSize, WriteMonitor monitor) {
        this.pendingUpdates = new EntityTokenUpdate[batchSize];
        this.addMerger = new AddMerger(monitor);
        this.removeMerger = (existingKey, newKey, existingValue, newValue) -> {
            monitor.mergeRemove((TokenScanValue)existingValue, (TokenScanValue)newValue);
            existingValue.remove((TokenScanValue)newValue);
            return existingValue.isEmpty() ? ValueMerger.MergeResult.REMOVED : ValueMerger.MergeResult.MERGED;
        };
        this.monitor = monitor;
    }

    NativeTokenScanWriter initialize(Writer<TokenScanKey, TokenScanValue> writer) {
        this.writer = writer;
        this.pendingUpdatesCursor = 0;
        this.addition = false;
        this.lowestTokenId = Long.MAX_VALUE;
        return this;
    }

    @Override
    public void write(EntityTokenUpdate update) throws IOException {
        if (this.pendingUpdatesCursor == this.pendingUpdates.length) {
            this.flushPendingChanges();
        }
        this.pendingUpdates[this.pendingUpdatesCursor++] = update;
        PhysicalToLogicalTokenChanges.convertToAdditionsAndRemovals(update);
        this.checkNextTokenId(update.getTokensBefore());
        this.checkNextTokenId(update.getTokensAfter());
    }

    private void checkNextTokenId(long[] tokens) {
        if (tokens.length > 0 && tokens[0] != -1L) {
            this.lowestTokenId = Long.min(this.lowestTokenId, tokens[0]);
        }
    }

    private void flushPendingChanges() {
        Arrays.sort(this.pendingUpdates, 0, this.pendingUpdatesCursor, UPDATE_SORTER);
        this.monitor.flushPendingUpdates();
        long currentTokenId = this.lowestTokenId;
        this.value.clear();
        this.key.clear();
        while (currentTokenId != Long.MAX_VALUE) {
            long nextTokenId = Long.MAX_VALUE;
            for (int i = 0; i < this.pendingUpdatesCursor; ++i) {
                EntityTokenUpdate update = this.pendingUpdates[i];
                long entityId = update.getEntityId();
                nextTokenId = this.extractChange(update.getTokensAfter(), currentTokenId, entityId, nextTokenId, true, update.getTxId());
                nextTokenId = this.extractChange(update.getTokensBefore(), currentTokenId, entityId, nextTokenId, false, update.getTxId());
            }
            currentTokenId = nextTokenId;
        }
        this.flushPendingRange();
        this.pendingUpdatesCursor = 0;
    }

    private long extractChange(long[] tokens, long currentTokenId, long entityId, long nextTokenId, boolean addition, long txId) {
        long tokenId;
        long foundNextTokenId = nextTokenId;
        for (int li = 0; li < tokens.length && (tokenId = tokens[li]) != -1L; ++li) {
            if (tokenId == currentTokenId) {
                this.change(currentTokenId, entityId, addition, txId);
                if (li + 1 >= tokens.length || tokens[li + 1] == -1L) break;
                long nextTokenCandidate = tokens[li + 1];
                if (nextTokenCandidate < currentTokenId) {
                    throw new IllegalArgumentException("The entity token contained unsorted tokens ids " + Arrays.toString(tokens));
                }
                if (nextTokenCandidate <= currentTokenId) break;
                foundNextTokenId = Long.min(foundNextTokenId, nextTokenCandidate);
                break;
            }
            if (tokenId <= currentTokenId) continue;
            foundNextTokenId = Long.min(foundNextTokenId, tokenId);
        }
        return foundNextTokenId;
    }

    private void change(long currentTokenId, long entityId, boolean add, long txId) {
        int tokenId = Math.toIntExact(currentTokenId);
        long idRange = NativeTokenScanWriter.rangeOf(entityId);
        if (tokenId != this.key.tokenId || idRange != this.key.idRange || this.addition != add) {
            this.flushPendingRange();
            this.key.tokenId = tokenId;
            this.key.idRange = idRange;
            this.addition = add;
            this.monitor.range(idRange, tokenId);
        }
        int offset = Math.toIntExact(entityId % 64L);
        this.value.set(offset);
        if (this.addition) {
            this.monitor.prepareAdd(txId, offset);
        } else {
            this.monitor.prepareRemove(txId, offset);
        }
    }

    private void flushPendingRange() {
        if (this.value.bits != 0L) {
            if (this.addition) {
                this.writer.merge((Object)this.key, (Object)this.value, this.addMerger);
            } else {
                this.writer.mergeIfExists((Object)this.key, (Object)this.value, this.removeMerger);
            }
            this.value.clear();
        }
    }

    static long rangeOf(long entityId) {
        return entityId / 64L;
    }

    static int offsetOf(long entityId) {
        return (int)(entityId % 64L);
    }

    @Override
    public void close() throws IOException {
        try {
            this.flushPendingChanges();
            this.monitor.writeSessionEnded();
        }
        finally {
            this.writer.close();
        }
    }

    static interface WriteMonitor {
        default public void range(long range, int tokenId) {
        }

        default public void prepareAdd(long txId, int offset) {
        }

        default public void prepareRemove(long txId, int offset) {
        }

        default public void mergeAdd(TokenScanValue existingValue, TokenScanValue newValue) {
        }

        default public void mergeRemove(TokenScanValue existingValue, TokenScanValue newValue) {
        }

        default public void flushPendingUpdates() {
        }

        default public void writeSessionEnded() {
        }

        default public void force() {
        }

        default public void close() {
        }
    }
}

