/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.Optional;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.kernel.api.exceptions.Status;

public class SyntaxException
extends Neo4jException {
    private final Optional<Integer> offset;
    private final String query;

    public SyntaxException(String message, String query, Optional<Integer> offset, Throwable cause) {
        super(message, cause);
        this.offset = offset;
        this.query = query;
    }

    public SyntaxException(String message, String query, int offset) {
        this(message, query, Optional.of(offset), null);
    }

    public SyntaxException(String message, String query, int offset, Throwable cause) {
        this(message, query, Optional.of(offset), cause);
    }

    public SyntaxException(String message, Throwable cause) {
        this(message, "", Optional.empty(), cause);
    }

    public SyntaxException(String message) {
        this(message, "", Optional.empty(), null);
    }

    @Override
    public Status status() {
        return Status.Statement.SyntaxError;
    }

    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @Override
    public String getMessage() {
        if (this.offset.isPresent()) {
            String[] stringArray;
            String[] split = this.query.split("\n");
            String string = super.getMessage();
            String string2 = System.lineSeparator();
            int n = this.offset.get();
            if (split.length != 0) {
                stringArray = split;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            return string + string2 + this.findErrorLine(n, stringArray);
        }
        return super.getMessage();
    }

    private String findErrorLine(int offset, String[] message) {
        int currentOffset = offset;
        if (message.length == 0) {
            throw new IllegalArgumentException("message converted to empty list");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < message.length; ++i) {
            String element = message[i];
            if (i < message.length - 1) {
                if (element.length() >= currentOffset) {
                    this.buildErrorString(builder, element, currentOffset);
                    break;
                }
                currentOffset -= element.length() + 1;
                continue;
            }
            this.buildErrorString(builder, element, Math.min(element.length(), currentOffset));
        }
        return builder.toString();
    }

    private void buildErrorString(StringBuilder builder, String element, int currentOffset) {
        builder.append("\"").append(element.stripTrailing()).append("\"").append(System.lineSeparator()).append(" ".repeat(currentOffset + 1)).append('^');
    }
}

