/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.hashing;

import org.neo4j.hashing.HashFunction;

class IncrementalXXH64
implements HashFunction {
    static final HashFunction INSTANCE = new IncrementalXXH64();
    private static final long Prime1 = -7046029288634856825L;
    private static final long Prime2 = -4417276706812531889L;
    private static final long Prime3 = 1609587929392839161L;
    private static final long Prime4 = -8796714831421723037L;
    private static final long Prime5 = 2870177450012600261L;

    private IncrementalXXH64() {
    }

    @Override
    public long initialise(long seed) {
        return seed + 2870177450012600261L;
    }

    @Override
    public long update(long hash, long block) {
        hash += 8L;
        block *= -4417276706812531889L;
        block = Long.rotateLeft(block, 31);
        hash ^= (block *= -7046029288634856825L);
        hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
        return hash;
    }

    @Override
    public long finalise(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }
}

