/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.os;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public final class OsBeanUtil {
    public static final long VALUE_UNAVAILABLE = -1L;
    private static final String SUN_OS_BEAN = "com.sun.management.OperatingSystemMXBean";
    private static final String SUN_UNIX_OS_BEAN = "com.sun.management.UnixOperatingSystemMXBean";
    private static final String IBM_OS_BEAN = "com.ibm.lang.management.OperatingSystemMXBean";
    private static final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getTotalPhysicalMemoryMethod = OsBeanUtil.findOsBeanMethod("getTotalPhysicalMemorySize", "getTotalPhysicalMemory");
    private static final Method getFreePhysicalMemoryMethod = OsBeanUtil.findOsBeanMethod("getFreePhysicalMemorySize", "getFreePhysicalMemorySize");
    private static final Method getCommittedVirtualMemoryMethod = OsBeanUtil.findOsBeanMethod("getCommittedVirtualMemorySize", null);
    private static final Method getTotalSwapSpaceMethod = OsBeanUtil.findOsBeanMethod("getTotalSwapSpaceSize", "getTotalSwapSpaceSize");
    private static final Method getFreeSwapSpaceMethod = OsBeanUtil.findOsBeanMethod("getFreeSwapSpaceSize", "getFreeSwapSpaceSize");
    private static final Method getMaxFileDescriptorsMethod = OsBeanUtil.findUnixOsBeanMethod("getMaxFileDescriptorCount");
    private static final Method getOpenFileDescriptorsMethod = OsBeanUtil.findUnixOsBeanMethod("getOpenFileDescriptorCount");

    private OsBeanUtil() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static long getTotalPhysicalMemory() {
        return OsBeanUtil.invoke(getTotalPhysicalMemoryMethod);
    }

    public static long getFreePhysicalMemory() {
        return OsBeanUtil.invoke(getFreePhysicalMemoryMethod);
    }

    public static long getCommittedVirtualMemory() {
        return OsBeanUtil.invoke(getCommittedVirtualMemoryMethod);
    }

    public static long getTotalSwapSpace() {
        return OsBeanUtil.invoke(getTotalSwapSpaceMethod);
    }

    public static long getFreeSwapSpace() {
        return OsBeanUtil.invoke(getFreeSwapSpaceMethod);
    }

    public static long getMaxFileDescriptors() {
        return OsBeanUtil.invoke(getMaxFileDescriptorsMethod);
    }

    public static long getOpenFileDescriptors() {
        return OsBeanUtil.invoke(getOpenFileDescriptorsMethod);
    }

    private static Method findOsBeanMethod(String sunMethodName, String ibmMethodName) {
        Method sunOsBeanMethod = OsBeanUtil.findSunOsBeanMethod(sunMethodName);
        return sunOsBeanMethod == null ? OsBeanUtil.findIbmOsBeanMethod(ibmMethodName) : sunOsBeanMethod;
    }

    private static Method findUnixOsBeanMethod(String methodName) {
        return OsBeanUtil.findMethod(SUN_UNIX_OS_BEAN, methodName);
    }

    private static Method findSunOsBeanMethod(String methodName) {
        return OsBeanUtil.findMethod(SUN_OS_BEAN, methodName);
    }

    private static Method findIbmOsBeanMethod(String methodName) {
        return OsBeanUtil.findMethod(IBM_OS_BEAN, methodName);
    }

    private static Method findMethod(String className, String methodName) {
        try {
            return methodName == null ? null : Class.forName(className).getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static long invoke(Method method) {
        try {
            Object value = method == null ? null : method.invoke((Object)osBean, new Object[0]);
            return value == null ? -1L : ((Number)value).longValue();
        }
        catch (Throwable t) {
            return -1L;
        }
    }
}

