/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.fusesource.jansi.internal.CLibrary;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.Historian;
import org.neo4j.shell.UserMessagesHandler;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.FileHistorian;
import org.neo4j.shell.cli.InteractiveShellRunner;
import org.neo4j.shell.cli.NonInteractiveShellRunner;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.ShellStatementParser;
import org.neo4j.shell.system.Utils;

public interface ShellRunner {
    @Nonnull
    public static ShellRunner getShellRunner(@Nonnull CliArgs cliArgs, @Nonnull CypherShell cypherShell, @Nonnull Logger logger, @Nonnull ConnectionConfig connectionConfig) throws IOException {
        if (ShellRunner.shouldBeInteractive(cliArgs)) {
            UserMessagesHandler userMessagesHandler = new UserMessagesHandler(connectionConfig, cypherShell.getServerVersion());
            return new InteractiveShellRunner(cypherShell, cypherShell, cypherShell, logger, new ShellStatementParser(), System.in, FileHistorian.getDefaultHistoryFile(), userMessagesHandler, connectionConfig);
        }
        return new NonInteractiveShellRunner(cliArgs.getFailBehavior(), cypherShell, logger, new ShellStatementParser(), ShellRunner.getInputStream(cliArgs));
    }

    public static boolean shouldBeInteractive(@Nonnull CliArgs cliArgs) {
        if (cliArgs.getNonInteractive() || cliArgs.getInputFilename() != null) {
            return false;
        }
        return ShellRunner.isInputInteractive();
    }

    public static boolean isInputInteractive() {
        if (Utils.isWindows()) {
            return System.console() != null;
        }
        try {
            return 1 == CLibrary.isatty(CLibrary.STDIN_FILENO);
        }
        catch (Throwable ignored) {
            return System.console() != null;
        }
    }

    public static boolean isOutputInteractive() {
        if (Utils.isWindows()) {
            return System.console() != null;
        }
        try {
            return 1 == CLibrary.isatty(CLibrary.STDOUT_FILENO);
        }
        catch (Throwable ignored) {
            return System.console() != null;
        }
    }

    public static InputStream getInputStream(CliArgs cliArgs) throws FileNotFoundException {
        if (cliArgs.getInputFilename() == null) {
            return System.in;
        }
        return new BufferedInputStream(new FileInputStream(new File(cliArgs.getInputFilename())));
    }

    public static OutputStream getOutputStreamForInteractivePrompt() {
        block6: {
            if (Utils.isWindows()) {
                if (System.console() != null) {
                    return new WriterOutputStream((Writer)System.console().writer(), Charset.defaultCharset());
                }
            } else {
                try {
                    if (1 == CLibrary.isatty(CLibrary.STDOUT_FILENO)) {
                        return System.out;
                    }
                    return new FileOutputStream(new File("/dev/tty"));
                }
                catch (Throwable ignored) {
                    if (System.console() == null) break block6;
                    return new WriterOutputStream((Writer)System.console().writer(), Charset.defaultCharset());
                }
            }
        }
        return new NullOutputStream();
    }

    public int runUntilEnd();

    @Nonnull
    public Historian getHistorian();
}

