/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import jline.console.ConsoleReader;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.Historian;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.UserMessagesHandler;
import org.neo4j.shell.cli.FileHistorian;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.exception.NoMoreInputException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.StatementParser;
import org.neo4j.shell.prettyprint.OutputFormatter;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class InteractiveShellRunner
implements ShellRunner,
SignalHandler {
    static final String INTERRUPT_SIGNAL = "INT";
    static final String UNRESOLVED_DEFAULT_DB_PROPMPT_TEXT = "<default_database>";
    static final String DATABASE_UNAVAILABLE_ERROR_PROMPT_TEXT = "[UNAVAILABLE]";
    private static final String FRESH_PROMPT = "> ";
    private static final String TRANSACTION_PROMPT = "# ";
    private static final String USERNAME_DB_DELIMITER = "@";
    private static final int ONELINE_PROMPT_MAX_LENGTH = 50;
    private final AtomicBoolean currentlyExecuting;
    @Nonnull
    private final Logger logger;
    @Nonnull
    private final ConsoleReader reader;
    @Nonnull
    private final Historian historian;
    @Nonnull
    private final StatementParser statementParser;
    @Nonnull
    private final TransactionHandler txHandler;
    @Nonnull
    private final DatabaseManager databaseManager;
    @Nonnull
    private final StatementExecuter executer;
    @Nonnull
    private final UserMessagesHandler userMessagesHandler;
    @Nonnull
    private final ConnectionConfig connectionConfig;
    private AnsiFormattedText continuationPrompt;

    public InteractiveShellRunner(@Nonnull StatementExecuter executer, @Nonnull TransactionHandler txHandler, @Nonnull DatabaseManager databaseManager, @Nonnull Logger logger, @Nonnull StatementParser statementParser, @Nonnull InputStream inputStream, @Nonnull File historyFile, @Nonnull UserMessagesHandler userMessagesHandler, @Nonnull ConnectionConfig connectionConfig) throws IOException {
        this.userMessagesHandler = userMessagesHandler;
        this.currentlyExecuting = new AtomicBoolean(false);
        this.executer = executer;
        this.txHandler = txHandler;
        this.databaseManager = databaseManager;
        this.logger = logger;
        this.statementParser = statementParser;
        this.reader = this.setupConsoleReader(logger, inputStream);
        this.historian = FileHistorian.setupHistory(this.reader, logger, historyFile);
        this.connectionConfig = connectionConfig;
        Signal.handle(new Signal(INTERRUPT_SIGNAL), this);
    }

    private ConsoleReader setupConsoleReader(@Nonnull Logger logger, @Nonnull InputStream inputStream) throws IOException {
        ConsoleReader reader = new ConsoleReader(inputStream, logger.getOutputStream());
        reader.setExpandEvents(false);
        reader.setHandleUserInterrupt(false);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runUntilEnd() {
        int exitCode = 0;
        boolean running = true;
        this.logger.printIfVerbose(this.userMessagesHandler.getWelcomeMessage());
        while (running) {
            try {
                for (String statement : this.readUntilStatement()) {
                    this.currentlyExecuting.set(true);
                    this.executer.execute(statement);
                    this.currentlyExecuting.set(false);
                }
            }
            catch (ExitException e) {
                exitCode = e.getCode();
                running = false;
            }
            catch (NoMoreInputException e) {
                running = false;
            }
            catch (Throwable e) {
                this.logger.printError(e);
            }
            finally {
                this.currentlyExecuting.set(false);
            }
        }
        this.logger.printIfVerbose(this.userMessagesHandler.getExitMessage());
        return exitCode;
    }

    @Override
    @Nonnull
    public Historian getHistorian() {
        return this.historian;
    }

    @Nonnull
    public List<String> readUntilStatement() throws IOException, NoMoreInputException {
        while (true) {
            String line;
            if ((line = this.reader.readLine(this.updateAndGetPrompt().renderedString())) == null) {
                throw new NoMoreInputException();
            }
            if (line.trim().isEmpty() && !this.statementParser.containsText()) continue;
            this.statementParser.parseMoreText(line + "\n");
            if (this.statementParser.hasStatements()) break;
        }
        return this.statementParser.consumeStatements();
    }

    AnsiFormattedText updateAndGetPrompt() {
        if (this.statementParser.containsText()) {
            return this.continuationPrompt;
        }
        String databaseName = this.databaseManager.getActualDatabaseAsReportedByServer();
        if (databaseName == null || "".equals(databaseName)) {
            String dbNameSetByUser = this.databaseManager.getActiveDatabaseAsSetByUser();
            databaseName = "".equals(dbNameSetByUser) ? UNRESOLVED_DEFAULT_DB_PROPMPT_TEXT : dbNameSetByUser;
        }
        String errorSuffix = this.getErrorPrompt(this.executer.lastNeo4jErrorCode());
        int promptIndent = this.connectionConfig.username().length() + USERNAME_DB_DELIMITER.length() + databaseName.length() + errorSuffix.length() + FRESH_PROMPT.length();
        AnsiFormattedText prePrompt = AnsiFormattedText.s().bold().append(this.connectionConfig.username()).append(USERNAME_DB_DELIMITER).append(databaseName);
        if (!errorSuffix.isEmpty()) {
            prePrompt.colorRed().append(errorSuffix).colorDefault();
        }
        if (promptIndent <= 50) {
            this.continuationPrompt = AnsiFormattedText.s().bold().append(OutputFormatter.repeat(' ', promptIndent));
            return prePrompt.append(this.txHandler.isTransactionOpen() ? TRANSACTION_PROMPT : FRESH_PROMPT);
        }
        this.continuationPrompt = AnsiFormattedText.s().bold();
        return prePrompt.appendNewLine().append(this.txHandler.isTransactionOpen() ? TRANSACTION_PROMPT : FRESH_PROMPT);
    }

    private String getErrorPrompt(String errorCode) {
        String errorPromptSuffix = "Neo.TransientError.General.DatabaseUnavailable".equals(errorCode) ? DATABASE_UNAVAILABLE_ERROR_PROMPT_TEXT : "";
        return errorPromptSuffix;
    }

    @Override
    public void handle(Signal signal) {
        if (this.currentlyExecuting.get()) {
            this.executer.reset();
        } else {
            this.logger.printError(AnsiFormattedText.s().colorRed().append("\nInterrupted (Note that Cypher queries must end with a ").bold().append("semicolon. ").boldOff().append("Type ").bold().append(":exit").append(" ").boldOff().append("to exit the shell.)").formattedString());
            this.resetPrompt();
        }
    }

    private void resetPrompt() {
        try {
            boolean more = true;
            while (more) {
                more = this.reader.delete();
            }
            more = true;
            while (more) {
                more = this.reader.backspace();
            }
            this.statementParser.reset();
            this.reader.setPrompt(this.updateAndGetPrompt().renderedString());
            this.reader.redrawLine();
            this.reader.flush();
        }
        catch (IOException e) {
            this.logger.printError(e);
        }
    }
}

