/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.TernaryComparator;

public interface SequenceValue
extends Iterable<AnyValue> {
    public int length();

    public AnyValue value(int var1);

    @Override
    public Iterator<AnyValue> iterator();

    public IterationPreference iterationPreference();

    default public boolean equals(SequenceValue other) {
        if (other == null) {
            return false;
        }
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.equalsUsingRandomAccess(this, other);
        }
        return SequenceValue.equalsUsingIterators(this, other);
    }

    public static boolean equalsUsingRandomAccess(SequenceValue a, SequenceValue b) {
        boolean areEqual;
        boolean bl = areEqual = a.length() == b.length();
        for (int i = 0; areEqual && i < a.length(); ++i) {
            areEqual = a.value(i).equals(b.value(i));
        }
        return areEqual;
    }

    public static Equality ternaryEqualsUsingRandomAccess(SequenceValue a, SequenceValue b) {
        int length2 = a.length();
        if (length2 != b.length()) {
            return Equality.FALSE;
        }
        Equality equivalenceResult = Equality.TRUE;
        for (int i = 0; i < length2; ++i) {
            Equality areEqual = a.value(i).ternaryEquals(b.value(i));
            if (areEqual == Equality.UNDEFINED) {
                equivalenceResult = Equality.UNDEFINED;
                continue;
            }
            if (areEqual != Equality.FALSE) continue;
            return Equality.FALSE;
        }
        return equivalenceResult;
    }

    public static boolean equalsUsingIterators(SequenceValue a, SequenceValue b) {
        boolean areEqual = true;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (areEqual && aIterator.hasNext() && bIterator.hasNext()) {
            areEqual = aIterator.next().equals(bIterator.next());
        }
        return areEqual && aIterator.hasNext() == bIterator.hasNext();
    }

    public static Equality ternaryEqualsUsingIterators(SequenceValue a, SequenceValue b) {
        Equality equivalenceResult = Equality.TRUE;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (aIterator.hasNext() && bIterator.hasNext()) {
            Equality areEqual = aIterator.next().ternaryEquals(bIterator.next());
            if (areEqual == Equality.UNDEFINED) {
                equivalenceResult = Equality.UNDEFINED;
                continue;
            }
            if (areEqual != Equality.FALSE) continue;
            return Equality.FALSE;
        }
        return !aIterator.hasNext() && !bIterator.hasNext() ? equivalenceResult : Equality.FALSE;
    }

    default public int compareToSequence(SequenceValue other, Comparator<AnyValue> comparator) {
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.compareUsingRandomAccess(this, other, comparator);
        }
        return SequenceValue.compareUsingIterators(this, other, comparator);
    }

    default public Comparison ternaryCompareToSequence(SequenceValue other, TernaryComparator<AnyValue> comparator) {
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.ternaryCompareUsingRandomAccess(this, other, comparator);
        }
        return SequenceValue.ternaryCompareUsingIterators(this, other, comparator);
    }

    public static int compareUsingRandomAccess(SequenceValue a, SequenceValue b, Comparator<AnyValue> comparator) {
        int x = 0;
        int length2 = Math.min(a.length(), b.length());
        for (int i = 0; x == 0 && i < length2; ++i) {
            x = comparator.compare(a.value(i), b.value(i));
        }
        if (x == 0) {
            x = a.length() - b.length();
        }
        return x;
    }

    public static int compareUsingIterators(SequenceValue a, SequenceValue b, Comparator<AnyValue> comparator) {
        int x = 0;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (x == 0 && aIterator.hasNext() && bIterator.hasNext()) {
            x = comparator.compare(aIterator.next(), bIterator.next());
        }
        if (x == 0) {
            x = Boolean.compare(aIterator.hasNext(), bIterator.hasNext());
        }
        return x;
    }

    public static Comparison ternaryCompareUsingRandomAccess(SequenceValue a, SequenceValue b, TernaryComparator<AnyValue> comparator) {
        Comparison cmp = Comparison.EQUAL;
        int length2 = Math.min(a.length(), b.length());
        for (int i = 0; cmp == Comparison.EQUAL && i < length2; ++i) {
            cmp = comparator.ternaryCompare(a.value(i), b.value(i));
        }
        if (cmp == Comparison.EQUAL) {
            cmp = Comparison.from(a.length() - b.length());
        }
        return cmp;
    }

    public static Comparison ternaryCompareUsingIterators(SequenceValue a, SequenceValue b, TernaryComparator<AnyValue> comparator) {
        Comparison cmp = Comparison.EQUAL;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (cmp == Comparison.EQUAL && aIterator.hasNext() && bIterator.hasNext()) {
            cmp = comparator.ternaryCompare(aIterator.next(), bIterator.next());
        }
        if (cmp == Comparison.EQUAL) {
            cmp = Comparison.from(Boolean.compare(aIterator.hasNext(), bIterator.hasNext()));
        }
        return cmp;
    }

    default public Equality ternaryEquality(SequenceValue other) {
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.ternaryEqualsUsingRandomAccess(this, other);
        }
        return SequenceValue.ternaryEqualsUsingIterators(this, other);
    }

    public static enum IterationPreference {
        RANDOM_ACCESS,
        ITERATION;

    }
}

