/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.OffsetTime;
import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public class TimeArray
extends TemporalArray<OffsetTime> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TimeArray.class);
    private final OffsetTime[] value;

    TimeArray(OffsetTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected OffsetTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapTimeArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(OffsetTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.writeTo(writer, ValueWriter.ArrayType.ZONED_TIME, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.ZONED_TIME_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((TimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "TimeArray";
    }

    @Override
    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray(HeapEstimator.OFFSET_TIME_SIZE, this.value.length);
    }
}

