/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.time;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class Stopwatch {
    private final long startTimeNano;
    private final Ticker ticker;

    public static Stopwatch start() {
        return new Stopwatch(System::nanoTime);
    }

    Stopwatch(Ticker ticker) {
        this.ticker = ticker;
        this.startTimeNano = ticker.get();
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.elapsed(TimeUnit.NANOSECONDS));
    }

    public long elapsed(TimeUnit unit) {
        return unit.convert(this.ticker.get() - this.startTimeNano, TimeUnit.NANOSECONDS);
    }

    public boolean hasTimedOut(Duration timeout) {
        return this.elapsed(TimeUnit.NANOSECONDS) >= timeout.toNanos();
    }

    public boolean hasTimedOut(long duration, TimeUnit unit) {
        return this.elapsed(TimeUnit.NANOSECONDS) >= unit.toNanos(duration);
    }

    static interface Ticker {
        public long get();
    }
}

