/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.lock;

import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.lock.LockWaitStrategies;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.WaitStrategy;

public enum ResourceTypes implements ResourceType
{
    NODE(0, LockWaitStrategies.INCREMENTAL_BACKOFF),
    RELATIONSHIP(1, LockWaitStrategies.INCREMENTAL_BACKOFF),
    INDEX_ENTRY(4, LockWaitStrategies.INCREMENTAL_BACKOFF),
    LABEL(6, LockWaitStrategies.INCREMENTAL_BACKOFF),
    RELATIONSHIP_TYPE(7, LockWaitStrategies.INCREMENTAL_BACKOFF),
    SCHEMA_NAME(8, LockWaitStrategies.INCREMENTAL_BACKOFF);

    private static final MutableIntObjectMap<ResourceType> idToType;
    private final int typeId;
    private final WaitStrategy waitStrategy;

    private ResourceTypes(int typeId, WaitStrategy waitStrategy) {
        this.typeId = typeId;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    @Override
    public WaitStrategy waitStrategy() {
        return this.waitStrategy;
    }

    public static ResourceType fromId(int typeId) {
        return (ResourceType)idToType.get(typeId);
    }

    static {
        idToType = new IntObjectHashMap();
        for (ResourceTypes resourceTypes : ResourceTypes.values()) {
            idToType.put(resourceTypes.typeId, (Object)resourceTypes);
        }
    }
}

