/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.LongConsumer;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdRange;
import org.neo4j.internal.id.IdRangeIterator;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.util.Preconditions;

public class BatchingIdGetter
implements IdSequence {
    private static final long NO_ID_EXPECTATION = -1L;
    private final IdGenerator source;
    private IdRangeIterator batch;
    private final int batchSize;
    private long idExpectation = -1L;

    BatchingIdGetter(CommonAbstractStore<? extends AbstractBaseRecord, ?> source) {
        this(source, source.getRecordsPerPage());
    }

    BatchingIdGetter(CommonAbstractStore<? extends AbstractBaseRecord, ?> source, int batchSize) {
        this.source = source.getIdGenerator();
        this.batchSize = batchSize;
    }

    public long nextId(PageCursorTracer cursorTracer) {
        long id;
        if (this.batch == null || (id = this.batch.nextId(cursorTracer)) == -1L) {
            this.idExpectation = -1L;
            IdRange idRange = this.source.nextIdBatch(this.batchSize, true, cursorTracer);
            while (IdValidator.hasReservedIdInRange((long)idRange.getRangeStart(), (long)(idRange.getRangeStart() + (long)idRange.getRangeLength()))) {
                idRange = this.source.nextIdBatch(this.batchSize, true, cursorTracer);
            }
            this.batch = new IdRangeIterator(idRange);
            id = this.batch.nextId(cursorTracer);
        }
        if (this.idExpectation != -1L) {
            Preconditions.checkState((id == this.idExpectation ? 1 : 0) != 0, (String)"Id generator allocated range with non-consecutive IDs, expected:%d, but got:%d", (Object[])new Object[]{this.idExpectation, id});
        }
        this.idExpectation = id + 1L;
        return id;
    }

    void visitUnused(LongConsumer visitor, PageCursorTracer cursorTracer) {
        if (this.batch != null) {
            long unusedId;
            while ((unusedId = this.batch.nextId(cursorTracer)) != -1L) {
                visitor.accept(unusedId);
            }
        }
    }
}

