/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RelationshipGroupCache;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class CacheGroupsStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private final RelationshipGroupCache cache;

    public CacheGroupsStep(StageControl control, Configuration config, RelationshipGroupCache cache, PageCacheTracer pageCacheTracer, StatsProvider ... additionalStatsProviders) {
        super(control, "CACHE", config, 1, pageCacheTracer, additionalStatsProviders);
        this.cache = cache;
    }

    @Override
    protected void process(RelationshipGroupRecord[] batch, BatchSender sender, PageCursorTracer cursorTracer) {
        for (int i = batch.length - 1; i >= 0; --i) {
            RelationshipGroupRecord record = batch[i];
            if (!record.inUse()) continue;
            this.cache.put(record);
        }
    }
}

