/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.staging.ForkedProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class CalculateDenseNodesStep
extends ForkedProcessorStep<RelationshipRecord[]> {
    private final NodeRelationshipCache cache;

    public CalculateDenseNodesStep(StageControl control, Configuration config, NodeRelationshipCache cache, StatsProvider ... statsProviders) {
        super(control, "CALCULATE", config, statsProviders);
        this.cache = cache;
    }

    @Override
    protected void forkedProcess(int id, int processors, RelationshipRecord[] batch) {
        for (RelationshipRecord record : batch) {
            if (!record.inUse()) continue;
            long startNodeId = record.getFirstNode();
            long endNodeId = record.getSecondNode();
            this.processNodeId(id, processors, startNodeId);
            if (startNodeId == endNodeId) continue;
            this.processNodeId(id, processors, endNodeId);
        }
    }

    private void processNodeId(int id, int processors, long nodeId) {
        if (nodeId % (long)processors == (long)id) {
            this.cache.incrementCount(nodeId);
        }
    }
}

