/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RelationshipGroupCache;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class CountGroupsStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private final RelationshipGroupCache cache;

    public CountGroupsStep(StageControl control, Configuration config, RelationshipGroupCache groupCache, PageCacheTracer pageCacheTracer, StatsProvider ... additionalStatsProviders) {
        super(control, "COUNT", config, 1, pageCacheTracer, additionalStatsProviders);
        this.cache = groupCache;
    }

    @Override
    protected void process(RelationshipGroupRecord[] batch, BatchSender sender, PageCursorTracer cursorTracer) {
        for (RelationshipGroupRecord record : batch) {
            if (!record.inUse()) continue;
            this.cache.incrementGroupCount(record.getOwningNode());
        }
    }
}

