/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.DataStatistics;
import org.neo4j.internal.batchimport.EntityImporter;
import org.neo4j.internal.batchimport.ExhaustingEntityImporterRunnable;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.MemoryUsageStatsProvider;
import org.neo4j.internal.batchimport.NodeImporter;
import org.neo4j.internal.batchimport.RelationshipImporter;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.internal.batchimport.stats.Stats;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.stats.StepStats;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.batchimport.store.io.IoMonitor;
import org.neo4j.internal.helpers.NamedThreadFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.MemoryTracker;

public class DataImporter {
    public static final String NODE_IMPORT_NAME = "Nodes";
    public static final String RELATIONSHIP_IMPORT_NAME = "Relationships";

    private static long importData(String title, Configuration configuration, InputIterable data, BatchingNeoStores stores, Supplier<EntityImporter> visitors, ExecutionMonitor executionMonitor, StatsProvider memoryStatsProvider) throws IOException {
        LongAdder roughEntityCountProgress = new LongAdder();
        int numRunners = configuration.maxNumberOfProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(numRunners, (ThreadFactory)new NamedThreadFactory(title + "Importer"));
        IoMonitor writeMonitor = new IoMonitor(stores.getIoTracer());
        ControllableStep step = new ControllableStep(title, roughEntityCountProgress, configuration, writeMonitor, memoryStatsProvider);
        StageExecution execution = new StageExecution(title, null, configuration, Collections.singletonList(step), 0);
        long startTime = System.currentTimeMillis();
        ArrayList<EntityImporter> importers = new ArrayList<EntityImporter>();
        try (InputIterator dataIterator = data.iterator();){
            executionMonitor.start(execution);
            for (int i = 0; i < numRunners; ++i) {
                EntityImporter importer = visitors.get();
                importers.add(importer);
                pool.submit(new ExhaustingEntityImporterRunnable(execution, dataIterator, importer, roughEntityCountProgress));
            }
            pool.shutdown();
            long nextWait = 0L;
            try {
                while (!pool.awaitTermination(nextWait, TimeUnit.MILLISECONDS)) {
                    executionMonitor.check(execution);
                    nextWait = executionMonitor.nextCheckTime() - System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        execution.assertHealthy();
        stores.markHighIds();
        importers.forEach(EntityImporter::freeUnusedIds);
        step.markAsCompleted();
        writeMonitor.stop();
        executionMonitor.end(execution, System.currentTimeMillis() - startTime);
        execution.assertHealthy();
        return roughEntityCountProgress.sum();
    }

    static void importNodes(Configuration configuration, Input input, BatchingNeoStores stores, IdMapper idMapper, Collector badCollector, ExecutionMonitor executionMonitor, Monitor monitor, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws IOException {
        Supplier<EntityImporter> importers = () -> new NodeImporter(stores, idMapper, monitor, pageCacheTracer, memoryTracker);
        DataImporter.importData(NODE_IMPORT_NAME, configuration, input.nodes(badCollector), stores, importers, executionMonitor, new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{stores, idMapper}));
    }

    static DataStatistics importRelationships(Configuration configuration, Input input, BatchingNeoStores stores, IdMapper idMapper, Collector badCollector, ExecutionMonitor executionMonitor, Monitor monitor, boolean validateRelationshipData, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws IOException {
        DataStatistics typeDistribution = new DataStatistics(monitor, new DataStatistics.RelationshipTypeCount[0]);
        Supplier<EntityImporter> importers = () -> new RelationshipImporter(stores, idMapper, typeDistribution, monitor, badCollector, validateRelationshipData, stores.usesDoubleRelationshipRecordUnits(), pageCacheTracer, memoryTracker);
        DataImporter.importData(RELATIONSHIP_IMPORT_NAME, configuration, input.relationships(badCollector), stores, importers, executionMonitor, new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{stores, idMapper}));
        return typeDistribution;
    }

    private static class ControllableStep
    implements Step<Void>,
    StatsProvider {
        private final String name;
        private final LongAdder progress;
        private final int batchSize;
        private final Key[] keys = new Key[]{Keys.done_batches, Keys.avg_processing_time};
        private final Collection<StatsProvider> statsProviders = new ArrayList<StatsProvider>();
        private final CountDownLatch completed = new CountDownLatch(1);

        ControllableStep(String name, LongAdder progress, Configuration config, StatsProvider ... additionalStatsProviders) {
            this.name = name;
            this.progress = progress;
            this.batchSize = config.batchSize();
            this.statsProviders.add(this);
            this.statsProviders.addAll(Arrays.asList(additionalStatsProviders));
        }

        void markAsCompleted() {
            this.completed.countDown();
        }

        @Override
        public void receivePanic(Throwable cause) {
        }

        @Override
        public void start(int orderingGuarantees) {
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public long receive(long ticket, Void batch) {
            return 0L;
        }

        @Override
        public StepStats stats() {
            return new StepStats(this.name, !this.isCompleted(), this.statsProviders);
        }

        @Override
        public void endOfUpstream() {
        }

        @Override
        public boolean isCompleted() {
            return this.completed.getCount() == 0L;
        }

        @Override
        public void awaitCompleted() throws InterruptedException {
            this.completed.await();
        }

        @Override
        public void setDownstream(Step<?> downstreamStep) {
        }

        @Override
        public void close() {
        }

        @Override
        public Stat stat(Key key) {
            if (key == Keys.done_batches) {
                return Stats.longStat(this.progress.sum() / (long)this.batchSize);
            }
            if (key == Keys.avg_processing_time) {
                return Stats.longStat(10L);
            }
            return null;
        }

        @Override
        public Key[] keys() {
            return this.keys;
        }
    }

    public static class Monitor {
        private final LongAdder nodes = new LongAdder();
        private final LongAdder relationships = new LongAdder();
        private final LongAdder properties = new LongAdder();

        public void nodesImported(long nodes) {
            this.nodes.add(nodes);
        }

        public void nodesRemoved(long nodes) {
            this.nodes.add(-nodes);
        }

        public void relationshipsImported(long relationships) {
            this.relationships.add(relationships);
        }

        public void propertiesImported(long properties) {
            this.properties.add(properties);
        }

        public void propertiesRemoved(long properties) {
            this.properties.add(-properties);
        }

        public long nodesImported() {
            return this.nodes.sum();
        }

        public long propertiesImported() {
            return this.properties.sum();
        }

        public String toString() {
            return String.format("Imported:%n  %d nodes%n  %d relationships%n  %d properties", this.nodes.sum(), this.relationships.sum(), this.properties.sum());
        }
    }
}

