/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.staging.LonelyProcessingStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class DeleteDuplicateNodesStep
extends LonelyProcessingStep {
    private static final String DELETE_DUPLICATE_IMPORT_STEP_TAG = "deleteDuplicateImportStep";
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final LongIterator nodeIds;
    private final DataImporter.Monitor storeMonitor;
    private final PageCacheTracer pageCacheTracer;
    private long nodesRemoved;
    private long propertiesRemoved;

    public DeleteDuplicateNodesStep(StageControl control, Configuration config, LongIterator nodeIds, NodeStore nodeStore, PropertyStore propertyStore, DataImporter.Monitor storeMonitor, PageCacheTracer pageCacheTracer) {
        super(control, "DEDUP", config, new StatsProvider[0]);
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.nodeIds = nodeIds;
        this.storeMonitor = storeMonitor;
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    protected void process() {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        PropertyRecord propertyRecord = this.propertyStore.newRecord();
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(DELETE_DUPLICATE_IMPORT_STEP_TAG);
             PageCursor cursor = this.nodeStore.openPageCursorForReading(0L, cursorTracer);
             PageCursor propertyCursor = this.propertyStore.openPageCursorForReading(0L, cursorTracer);){
            while (this.nodeIds.hasNext()) {
                long duplicateNodeId = this.nodeIds.next();
                this.nodeStore.getRecordByCursor(duplicateNodeId, nodeRecord, RecordLoad.NORMAL, cursor);
                assert (nodeRecord.inUse()) : nodeRecord;
                this.nodeStore.ensureHeavy(nodeRecord, cursorTracer);
                long nextProp = nodeRecord.getNextProp();
                while (!Record.NULL_REFERENCE.is(nextProp)) {
                    this.propertyStore.getRecordByCursor(nextProp, propertyRecord, RecordLoad.NORMAL, propertyCursor);
                    assert (propertyRecord.inUse()) : propertyRecord + " for " + nodeRecord;
                    this.propertyStore.ensureHeavy(propertyRecord, cursorTracer);
                    this.propertiesRemoved += (long)propertyRecord.numberOfProperties();
                    nextProp = propertyRecord.getNextProp();
                    DeleteDuplicateNodesStep.deletePropertyRecordIncludingValueRecords(propertyRecord);
                    this.propertyStore.updateRecord(propertyRecord, cursorTracer);
                }
                nodeRecord.setInUse(false);
                for (DynamicRecord labelRecord : nodeRecord.getDynamicLabelRecords()) {
                    labelRecord.setInUse(false);
                }
                this.nodeStore.updateRecord(nodeRecord, cursorTracer);
                ++this.nodesRemoved;
            }
        }
    }

    private static void deletePropertyRecordIncludingValueRecords(PropertyRecord record) {
        for (PropertyBlock block : record) {
            for (DynamicRecord valueRecord : block.getValueRecords()) {
                assert (valueRecord.inUse());
                valueRecord.setInUse(false);
                record.addDeletedRecord(valueRecord);
            }
        }
        record.clearPropertyBlocks();
        record.setInUse(false);
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.storeMonitor.nodesRemoved(this.nodesRemoved);
        this.storeMonitor.propertiesRemoved(this.propertiesRemoved);
    }
}

