/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class EncodeGroupsStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private long nextId = -1L;
    private final RecordStore<RelationshipGroupRecord> store;

    public EncodeGroupsStep(StageControl control, Configuration config, RecordStore<RelationshipGroupRecord> store, PageCacheTracer pageCacheTracer) {
        super(control, "ENCODE", config, 1, pageCacheTracer, new StatsProvider[0]);
        this.store = store;
    }

    @Override
    protected void process(RelationshipGroupRecord[] batch, BatchSender sender, PageCursorTracer cursorTracer) {
        int groupStartIndex = 0;
        for (int i = 0; i < batch.length; ++i) {
            long l;
            boolean lastInChain;
            RelationshipGroupRecord group = batch[i];
            long count = group.getNext();
            boolean bl = lastInChain = count == 0L;
            if (this.nextId == -1L) {
                l = this.store.nextId(cursorTracer);
                this.nextId = this.nextId;
            } else {
                l = this.nextId;
            }
            group.setId(l);
            if (!lastInChain) {
                this.nextId = this.store.nextId(cursorTracer);
                group.setNext(this.nextId);
                continue;
            }
            this.nextId = -1L;
            group.setNext(-1L);
            for (int j = groupStartIndex; j <= i; ++j) {
                this.store.prepareForCommit(batch[j], cursorTracer);
            }
            groupStartIndex = i + 1;
        }
        assert (groupStartIndex == batch.length);
        sender.send(batch);
    }
}

