/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.internal.batchimport.EntityImporter;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.staging.StageControl;

class ExhaustingEntityImporterRunnable
implements Runnable {
    private final InputIterator data;
    private final EntityImporter visitor;
    private final LongAdder roughEntityCountProgress;
    private final StageControl control;

    ExhaustingEntityImporterRunnable(StageControl control, InputIterator data, EntityImporter visitor, LongAdder roughEntityCountProgress) {
        this.control = control;
        this.data = data;
        this.visitor = visitor;
        this.roughEntityCountProgress = roughEntityCountProgress;
    }

    @Override
    public void run() {
        try (InputChunk chunk = this.data.newChunk();){
            while (this.data.next(chunk)) {
                this.control.assertHealthy();
                int count = 0;
                while (chunk.next((InputEntityVisitor)this.visitor)) {
                    ++count;
                }
                this.roughEntityCountProgress.add(count);
            }
        }
        catch (IOException e) {
            this.control.panic(e);
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            this.control.panic(e);
            throw e;
        }
        finally {
            this.visitor.close();
        }
    }
}

