/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.function.Predicates;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.DataStatistics;
import org.neo4j.internal.batchimport.DeleteDuplicateNodesStage;
import org.neo4j.internal.batchimport.HeapSizeSanityChecker;
import org.neo4j.internal.batchimport.IdMapperPreparationStage;
import org.neo4j.internal.batchimport.MemoryUsageStatsProvider;
import org.neo4j.internal.batchimport.NodeCountsAndLabelIndexBuildStage;
import org.neo4j.internal.batchimport.NodeDegreeCountStage;
import org.neo4j.internal.batchimport.NodeInputIdPropertyLookup;
import org.neo4j.internal.batchimport.RelationshipCountsAndTypeIndexBuildStage;
import org.neo4j.internal.batchimport.RelationshipGroupDefragmenter;
import org.neo4j.internal.batchimport.RelationshipGroupStage;
import org.neo4j.internal.batchimport.RelationshipLinkbackStage;
import org.neo4j.internal.batchimport.RelationshipLinkforwardStage;
import org.neo4j.internal.batchimport.RelationshipLinkingProgress;
import org.neo4j.internal.batchimport.SparseNodeFirstRelationshipStage;
import org.neo4j.internal.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.PageCacheArrayFactoryMonitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.IdMappers;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.EstimationSanityChecker;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.helpers.Format;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;

public class ImportLogic
implements Closeable {
    private static final String IMPORT_COUNT_STORE_REBUILD_TAG = "importCountStoreRebuild";
    public static final Monitor NO_MONITOR = new Monitor(){

        @Override
        public void mayExceedRelationshipIdCapacity(long capacity, long estimatedCount) {
        }

        @Override
        public void mayExceedNodeIdCapacity(long capacity, long estimatedCount) {
        }

        @Override
        public void doubleRelationshipRecordUnitsEnabled() {
        }

        @Override
        public void insufficientHeapSize(long optimalMinimalHeapSize, long heapSize) {
        }

        @Override
        public void abundantHeapSize(long optimalMinimalHeapSize, long heapSize) {
        }

        @Override
        public void insufficientAvailableMemory(long estimatedCacheSize, long optimalMinimalHeapSize, long availableMemory) {
        }
    };
    private final Path databaseDirectory;
    private final BatchingNeoStores neoStore;
    private final Configuration config;
    private final Config dbConfig;
    private final Log log;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;
    private final ExecutionMonitor executionMonitor;
    private final RecordFormats recordFormats;
    private final DataImporter.Monitor storeUpdateMonitor = new DataImporter.Monitor();
    private final long maxMemory;
    private final Dependencies dependencies = new Dependencies();
    private final Monitor monitor;
    private Input input;
    private boolean successful;
    private final Map<Class<?>, Object> accessibleState = new HashMap();
    private NodeRelationshipCache nodeRelationshipCache;
    private NodeLabelsCache nodeLabelsCache;
    private long startTime;
    private NumberArrayFactory numberArrayFactory;
    private final Collector badCollector;
    private IdMapper idMapper;
    private long peakMemoryUsage;
    private long availableMemoryForLinking;

    public ImportLogic(DatabaseLayout databaseLayout, BatchingNeoStores neoStore, Configuration config, Config dbConfig, LogService logService, ExecutionMonitor executionMonitor, RecordFormats recordFormats, Collector badCollector, Monitor monitor, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.databaseDirectory = databaseLayout.databaseDirectory();
        this.neoStore = neoStore;
        this.config = config;
        this.dbConfig = dbConfig;
        this.recordFormats = recordFormats;
        this.badCollector = badCollector;
        this.monitor = monitor;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
        this.executionMonitor = ExecutionSupervisors.withDynamicProcessorAssignment(executionMonitor, config);
        this.maxMemory = config.maxMemoryUsage();
    }

    public void initialize(Input input) throws IOException {
        this.log.info("Import starting");
        this.startTime = System.currentTimeMillis();
        this.input = input;
        PageCacheArrayFactoryMonitor numberArrayFactoryMonitor = new PageCacheArrayFactoryMonitor();
        this.numberArrayFactory = NumberArrayFactories.auto((PageCache)this.neoStore.getPageCache(), (PageCacheTracer)this.pageCacheTracer, (Path)this.databaseDirectory, (boolean)this.config.allowCacheAllocationOnHeap(), (NumberArrayFactory.Monitor)numberArrayFactoryMonitor, (Log)this.log);
        this.idMapper = this.instantiateIdMapper(input);
        this.nodeRelationshipCache = new NodeRelationshipCache(this.numberArrayFactory, ((Integer)this.dbConfig.get(GraphDatabaseSettings.dense_node_threshold)).intValue(), this.memoryTracker);
        Input.Estimates inputEstimates = input.calculateEstimates((PropertySizeCalculator)this.neoStore.getPropertyStore().newValueEncodedSizeCalculator());
        new EstimationSanityChecker(this.recordFormats, this.monitor).sanityCheck(inputEstimates);
        new HeapSizeSanityChecker(this.monitor).sanityCheck(inputEstimates, this.recordFormats, this.neoStore, this.nodeRelationshipCache.memoryEstimation(inputEstimates.numberOfNodes()), this.idMapper.memoryEstimation(inputEstimates.numberOfNodes()));
        this.dependencies.satisfyDependencies(new Object[]{inputEstimates, this.idMapper, this.neoStore, this.nodeRelationshipCache, numberArrayFactoryMonitor});
        if (this.neoStore.determineDoubleRelationshipRecordUnits(inputEstimates)) {
            this.monitor.doubleRelationshipRecordUnitsEnabled();
        }
        this.executionMonitor.initialize((DependencyResolver)this.dependencies);
    }

    private IdMapper instantiateIdMapper(Input input) {
        switch (input.idType()) {
            case STRING: {
                return IdMappers.strings((NumberArrayFactory)this.numberArrayFactory, (ReadableGroups)input.groups(), (PageCacheTracer)this.pageCacheTracer, (MemoryTracker)this.memoryTracker);
            }
            case INTEGER: {
                return IdMappers.longs((NumberArrayFactory)this.numberArrayFactory, (ReadableGroups)input.groups(), (PageCacheTracer)this.pageCacheTracer, (MemoryTracker)this.memoryTracker);
            }
            case ACTUAL: {
                return IdMappers.actual();
            }
        }
        throw new IllegalArgumentException("Unsupported id type " + input.idType());
    }

    public <T> T getState(Class<T> type) {
        return type.cast(this.accessibleState.get(type));
    }

    public <T> void putState(T state) {
        this.accessibleState.put(state.getClass(), state);
        this.dependencies.satisfyDependency(state);
    }

    public void importNodes() throws IOException {
        this.neoStore.startFlushingPageCache();
        DataImporter.importNodes(this.config, this.input, this.neoStore, this.idMapper, this.badCollector, this.executionMonitor, this.storeUpdateMonitor, this.pageCacheTracer, this.memoryTracker);
        this.neoStore.stopFlushingPageCache();
        this.updatePeakMemoryUsage();
    }

    public void prepareIdMapper() {
        if (this.idMapper.needsPreparation()) {
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{this.neoStore, this.idMapper});
            NodeInputIdPropertyLookup inputIdLookup = new NodeInputIdPropertyLookup(this.neoStore.getTemporaryPropertyStore());
            this.executeStage(new IdMapperPreparationStage(this.config, this.idMapper, inputIdLookup, this.badCollector, memoryUsageStats));
            LongIterator duplicateNodeIds = this.idMapper.leftOverDuplicateNodesIds();
            if (duplicateNodeIds.hasNext()) {
                this.executeStage(new DeleteDuplicateNodesStage(this.config, duplicateNodeIds, this.neoStore, this.storeUpdateMonitor, this.pageCacheTracer));
            }
            this.updatePeakMemoryUsage();
        }
    }

    public void importRelationships() throws IOException {
        this.neoStore.startFlushingPageCache();
        DataStatistics typeDistribution = DataImporter.importRelationships(this.config, this.input, this.neoStore, this.idMapper, this.badCollector, this.executionMonitor, this.storeUpdateMonitor, !this.badCollector.isCollectingBadRelationships(), this.pageCacheTracer, this.memoryTracker);
        this.neoStore.stopFlushingPageCache();
        this.updatePeakMemoryUsage();
        this.idMapper.close();
        this.idMapper = null;
        this.putState(typeDistribution);
    }

    public void calculateNodeDegrees() {
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        this.nodeRelationshipCache.setNodeCount(this.neoStore.getNodeStore().getHighId());
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{this.neoStore, this.nodeRelationshipCache});
        NodeDegreeCountStage nodeDegreeStage = new NodeDegreeCountStage(relationshipConfig, this.neoStore.getRelationshipStore(), this.nodeRelationshipCache, memoryUsageStats, this.pageCacheTracer);
        this.executeStage(nodeDegreeStage);
        this.nodeRelationshipCache.countingCompleted();
        this.availableMemoryForLinking = this.maxMemory - ImportLogic.totalMemoryUsageOf(new MemoryStatsVisitor.Visitable[]{this.nodeRelationshipCache, this.neoStore});
    }

    public int linkRelationships(int startingFromType) {
        assert (startingFromType >= 0) : startingFromType;
        DataStatistics relationshipTypeDistribution = this.getState(DataStatistics.class);
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{this.neoStore, this.nodeRelationshipCache});
        int upToType = ImportLogic.nextSetOfTypesThatFitInMemory(relationshipTypeDistribution, startingFromType, this.availableMemoryForLinking, this.nodeRelationshipCache.getNumberOfDenseNodes());
        IntSet typesToLinkThisRound = relationshipTypeDistribution.types(startingFromType, upToType);
        int typesImported = typesToLinkThisRound.size();
        boolean thisIsTheFirstRound = startingFromType == 0;
        boolean thisIsTheOnlyRound = thisIsTheFirstRound && upToType == relationshipTypeDistribution.getNumberOfRelationshipTypes();
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        Configuration nodeConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getNodeStore());
        Configuration groupConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipGroupStore());
        this.nodeRelationshipCache.setForwardScan(true, true);
        String range = typesToLinkThisRound.size() == 1 ? String.valueOf(ImportLogic.oneBased(startingFromType)) : ImportLogic.oneBased(startingFromType) + "-" + (startingFromType + typesImported);
        String topic = " " + range + "/" + relationshipTypeDistribution.getNumberOfRelationshipTypes();
        int nodeTypes = thisIsTheFirstRound ? 3 : 1;
        Predicate<RelationshipRecord> readFilter = thisIsTheFirstRound ? Predicates.alwaysTrue() : record -> typesToLinkThisRound.contains(record.getType());
        Predicate<RelationshipRecord> denseChangeFilter = thisIsTheOnlyRound ? Predicates.alwaysTrue() : record -> typesToLinkThisRound.contains(record.getType());
        RelationshipLinkforwardStage linkForwardStage = new RelationshipLinkforwardStage(topic, relationshipConfig, this.neoStore, this.nodeRelationshipCache, readFilter, denseChangeFilter, nodeTypes, this.pageCacheTracer, new RelationshipLinkingProgress(), memoryUsageStats);
        this.executeStage(linkForwardStage);
        this.executeStage(new RelationshipGroupStage(topic, groupConfig, this.neoStore.getTemporaryRelationshipGroupStore(), this.nodeRelationshipCache, this.pageCacheTracer));
        if (thisIsTheFirstRound) {
            this.executeStage(new SparseNodeFirstRelationshipStage(nodeConfig, this.neoStore.getNodeStore(), this.nodeRelationshipCache, this.pageCacheTracer));
        }
        this.nodeRelationshipCache.setForwardScan(false, true);
        this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, this.neoStore, this.nodeRelationshipCache, readFilter, denseChangeFilter, nodeTypes, this.pageCacheTracer, new RelationshipLinkingProgress(), memoryUsageStats));
        this.updatePeakMemoryUsage();
        if (upToType == relationshipTypeDistribution.getNumberOfRelationshipTypes()) {
            this.nodeRelationshipCache.close();
            this.nodeRelationshipCache = null;
            return -1;
        }
        return upToType;
    }

    public void linkRelationshipsOfAllTypes() {
        int type = 0;
        while ((type = this.linkRelationships(type)) != -1) {
        }
    }

    private static int oneBased(int value) {
        return value + 1;
    }

    static int nextSetOfTypesThatFitInMemory(DataStatistics typeDistribution, int startingFromType, long freeMemoryForDenseNodeCache, long numberOfDenseNodes) {
        DataStatistics.RelationshipTypeCount type;
        long relationshipCountForThisType;
        long memoryUsageUpToAndIncludingThisType;
        int toType;
        long memoryUsageForThisType;
        assert (startingFromType >= 0) : startingFromType;
        long currentSetOfRelationshipsMemoryUsage = 0L;
        int numberOfTypes = typeDistribution.getNumberOfRelationshipTypes();
        for (toType = startingFromType; toType < numberOfTypes && ((memoryUsageUpToAndIncludingThisType = currentSetOfRelationshipsMemoryUsage + (memoryUsageForThisType = NodeRelationshipCache.calculateMaxMemoryUsage((long)numberOfDenseNodes, (long)(relationshipCountForThisType = (type = typeDistribution.get(toType)).getCount())))) <= freeMemoryForDenseNodeCache || currentSetOfRelationshipsMemoryUsage <= 0L); currentSetOfRelationshipsMemoryUsage += memoryUsageForThisType, ++toType) {
        }
        return toType;
    }

    public void defragmentRelationshipGroups() {
        new RelationshipGroupDefragmenter(this.config, this.executionMonitor, RelationshipGroupDefragmenter.Monitor.EMPTY, this.numberArrayFactory, this.pageCacheTracer, this.memoryTracker).run(Long.max(this.maxMemory, this.peakMemoryUsage), this.neoStore, this.neoStore.getNodeStore().getHighId());
    }

    public void buildCountsStore() {
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(IMPORT_COUNT_STORE_REBUILD_TAG);){
            this.neoStore.buildCountsStore(new CountsBuilder(){

                @Override
                public void initialize(CountsAccessor.Updater updater, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
                    MigrationProgressMonitor progressMonitor = MigrationProgressMonitor.SILENT;
                    ImportLogic.this.nodeLabelsCache = new NodeLabelsCache(ImportLogic.this.numberArrayFactory, ImportLogic.this.neoStore.getNodeStore().getHighId(), ImportLogic.this.neoStore.getLabelRepository().getHighId(), memoryTracker);
                    MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{ImportLogic.this.neoStore, ImportLogic.this.nodeLabelsCache});
                    ImportLogic.this.executeStage(new NodeCountsAndLabelIndexBuildStage(ImportLogic.this.config, ImportLogic.this.nodeLabelsCache, ImportLogic.this.neoStore.getNodeStore(), ImportLogic.this.neoStore.getLabelRepository().getHighId(), updater, progressMonitor.startSection("Nodes"), ImportLogic.this.neoStore.getLabelScanStore(), ImportLogic.this.pageCacheTracer, memoryUsageStats));
                    ImportLogic.this.executeStage(new RelationshipCountsAndTypeIndexBuildStage(ImportLogic.this.config, ImportLogic.this.nodeLabelsCache, ImportLogic.this.neoStore.getRelationshipStore(), ImportLogic.this.neoStore.getLabelRepository().getHighId(), ImportLogic.this.neoStore.getRelationshipTypeRepository().getHighId(), updater, ImportLogic.this.numberArrayFactory, progressMonitor.startSection("Relationships"), ImportLogic.this.neoStore.getRelationshipTypeScanStore(), ImportLogic.this.pageCacheTracer, memoryTracker));
                }

                @Override
                public long lastCommittedTxId() {
                    return ImportLogic.this.neoStore.getLastCommittedTransactionId();
                }
            }, this.pageCacheTracer, cursorTracer, this.memoryTracker);
        }
    }

    public void success() {
        this.neoStore.success();
        this.successful = true;
    }

    @Override
    public void close() throws IOException {
        long totalTimeMillis = System.currentTimeMillis() - this.startTime;
        DataStatistics state = this.getState(DataStatistics.class);
        String additionalInformation = Objects.toString(state, "Data statistics is not available.");
        this.executionMonitor.done(this.successful, totalTimeMillis, String.format("%n%s%nPeak memory usage: %s", additionalInformation, ByteUnit.bytesToString((long)this.peakMemoryUsage)));
        this.log.info("Import completed successfully, took " + Format.duration((long)totalTimeMillis) + ". " + additionalInformation);
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.nodeRelationshipCache, this.nodeLabelsCache, this.idMapper});
    }

    private void updatePeakMemoryUsage() {
        this.peakMemoryUsage = Long.max(this.peakMemoryUsage, ImportLogic.totalMemoryUsageOf(new MemoryStatsVisitor.Visitable[]{this.nodeRelationshipCache, this.idMapper, this.neoStore}));
    }

    public static BatchingNeoStores instantiateNeoStores(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, PageCache externalPageCache, PageCacheTracer cacheTracer, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds additionalInitialIds, Config dbConfig, JobScheduler scheduler, MemoryTracker memoryTracker) {
        if (externalPageCache == null) {
            return BatchingNeoStores.batchingNeoStores(fileSystem, databaseLayout, recordFormats, config, logService, additionalInitialIds, dbConfig, scheduler, cacheTracer, memoryTracker);
        }
        return BatchingNeoStores.batchingNeoStoresWithExternalPageCache(fileSystem, externalPageCache, cacheTracer, databaseLayout, recordFormats, config, logService, additionalInitialIds, dbConfig, memoryTracker);
    }

    private static long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... users) {
        GatheringMemoryStatsVisitor total = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : users) {
            if (user == null) continue;
            user.acceptMemoryStatsVisitor((MemoryStatsVisitor)total);
        }
        return total.getHeapUsage() + total.getOffHeapUsage();
    }

    private static Configuration configWithRecordsPerPageBasedBatchSize(Configuration source, RecordStore<?> store) {
        return Configuration.withBatchSize((Configuration)source, (int)(store.getRecordsPerPage() * 10));
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, stage);
    }

    public static interface Monitor {
        public void doubleRelationshipRecordUnitsEnabled();

        public void mayExceedNodeIdCapacity(long var1, long var3);

        public void mayExceedRelationshipIdCapacity(long var1, long var3);

        public void insufficientHeapSize(long var1, long var3);

        public void abundantHeapSize(long var1, long var3);

        public void insufficientAvailableMemory(long var1, long var3, long var5);
    }
}

