/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.storageengine.api.EntityTokenUpdate;

public class LabelIndexWriterStep
extends ProcessorStep<NodeRecord[]> {
    private static final String INDEX_WRITE_STEP_TAG = "indexWriteStep";
    private final TokenScanWriter writer;
    private final NodeStore nodeStore;
    private final PageCursorTracer cursorTracer;

    public LabelIndexWriterStep(StageControl control, Configuration config, LabelScanStore store, NodeStore nodeStore, PageCacheTracer pageCacheTracer) {
        super(control, "LABEL INDEX", config, 1, pageCacheTracer, new StatsProvider[0]);
        this.cursorTracer = pageCacheTracer.createPageCursorTracer(INDEX_WRITE_STEP_TAG);
        this.writer = store.newBulkAppendWriter(this.cursorTracer);
        this.nodeStore = nodeStore;
    }

    @Override
    protected void process(NodeRecord[] batch, BatchSender sender, PageCursorTracer cursorTracer) throws Throwable {
        for (NodeRecord node : batch) {
            if (!node.inUse()) continue;
            this.writer.write(EntityTokenUpdate.tokenChanges((long)node.getId(), (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])NodeLabelsField.get(node, this.nodeStore, cursorTracer)));
        }
        sender.send(batch);
    }

    @Override
    public void close() throws Exception {
        super.close();
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.writer, this.cursorTracer});
    }
}

