/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.common.ProgressReporter;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.LabelIndexWriterStep;
import org.neo4j.internal.batchimport.NodeCountsProcessor;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.RecordProcessorStep;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeCountsAndLabelIndexBuildStage
extends Stage {
    public static final String NAME = "Node counts and label index build";

    public NodeCountsAndLabelIndexBuildStage(Configuration config, NodeLabelsCache cache, NodeStore nodeStore, int highLabelId, CountsAccessor.Updater countsUpdater, ProgressReporter progressReporter, LabelScanStore labelIndex, PageCacheTracer pageCacheTracer, StatsProvider ... additionalStatsProviders) {
        super(NAME, null, config, 3);
        this.add(new BatchFeedStep(this.control(), config, RecordIdIterator.withProgressReport(RecordIdIterator.allIn(nodeStore, config), progressReporter), nodeStore.getRecordSize()));
        this.add(new ReadRecordsStep<NodeRecord>(this.control(), config, false, nodeStore, pageCacheTracer));
        this.add(new LabelIndexWriterStep(this.control(), config, labelIndex, nodeStore, pageCacheTracer));
        this.add(new RecordProcessorStep(this.control(), "COUNT", config, () -> new NodeCountsProcessor(nodeStore, cache, highLabelId, countsUpdater), true, 0, pageCacheTracer, additionalStatsProviders));
    }
}

